/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.bn;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.misc.BigIntegerTools;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.helpers.FiniteFieldTools;
import org.cryptimeleon.math.structures.rings.zn.Zn;

class BarretoNaehrigHashToSourceGroupImpl
implements HashIntoGroupImpl {
    @Represented
    BarretoNaehrigSourceGroupImpl groupImpl;
    Field baseField;
    FieldElement b;
    FieldElement c1;
    FieldElement c2;
    HashFunction hashFunction1;
    HashFunction hashFunction2;

    public BarretoNaehrigHashToSourceGroupImpl(BarretoNaehrigSourceGroupImpl group1Impl) {
        this.groupImpl = group1Impl;
        this.baseField = this.groupImpl.getFieldOfDefinition();
        this.init(new VariableOutputLengthHashFunction((this.baseField.size().bitLength() - 1) / 8));
    }

    public BarretoNaehrigHashToSourceGroupImpl(BarretoNaehrigSourceGroupImpl group1Impl, HashFunction hashFunction) {
        this.groupImpl = group1Impl;
        this.baseField = this.groupImpl.getFieldOfDefinition();
        this.init(hashFunction);
    }

    public BarretoNaehrigHashToSourceGroupImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
        this.baseField = this.groupImpl.getFieldOfDefinition();
        this.init(new VariableOutputLengthHashFunction((this.baseField.size().bitLength() - 1) / 8));
    }

    @Override
    public GroupElementImpl hashIntoGroupImpl(byte[] x) {
        byte[] concat0X = new byte[1 + x.length];
        concat0X[0] = 0;
        System.arraycopy(x, 0, concat0X, 1, x.length);
        byte[] concat1X = new byte[1 + x.length];
        concat1X[0] = 1;
        System.arraycopy(x, 0, concat1X, 1, x.length);
        byte[] h1 = this.hashFunction1.hash(concat0X);
        BigInteger i1 = new BigInteger(h1);
        byte[] h2 = this.hashFunction2.hash(concat1X);
        BigInteger i2 = new BigInteger(h2);
        GroupElementImpl result = this.SWEncode(this.baseField.getElement(i1)).op(this.SWEncode(this.baseField.getElement(i2)));
        return this.groupImpl.multiplyByCofactor(result);
    }

    void init(HashFunction hashFunction) {
        this.b = this.groupImpl.getA6();
        this.hashFunction1 = hashFunction;
        this.hashFunction2 = hashFunction;
        this.c1 = FiniteFieldTools.sqrt(this.baseField.getElement(-3L));
        this.c2 = this.baseField.getOneElement().neg().add(this.c1).div(this.baseField.getElement(2L));
    }

    GroupElementImpl SWEncode(FieldElement t) {
        if (t.isZero()) {
            return this.groupImpl.getElement(this.c2, FiniteFieldTools.sqrt(this.baseField.getOneElement().add(this.b)));
        }
        FieldElement w = this.baseField.getOneElement().add(this.groupImpl.getA6().add(t.pow(2L))).inv().mul(t).mul(this.c1);
        FieldElement x1 = this.c2.add(t.mul(w).neg());
        FieldElement x2 = this.baseField.getOneElement().neg().add(x1.neg());
        FieldElement x3 = this.baseField.getOneElement().add(this.baseField.getOneElement().div(w.square()));
        FieldElement r1 = this.baseField.getUniformlyRandomUnit();
        FieldElement r2 = this.baseField.getUniformlyRandomUnit();
        FieldElement r3 = this.baseField.getUniformlyRandomUnit();
        int alpha = this.chi(r1.square().mul(x1.pow(3L).add(this.b)));
        int beta = this.chi(r2.square().mul(x2.pow(3L).add(this.b)));
        Zn z3 = new Zn(BigInteger.valueOf(3L));
        int i = BigIntegerTools.getExactInt(z3.createZnElement(BigInteger.valueOf((alpha - 1) * beta)).asInteger().add(BigInteger.ONE));
        if (i == 1) {
            FieldElement y = this.baseField.getElement(this.chi(r3.square().mul(t))).mul(FiniteFieldTools.sqrt(x1.pow(3L).add(this.b)));
            return this.groupImpl.getElement(x1, y);
        }
        if (i == 2) {
            FieldElement y = this.baseField.getElement(this.chi(r3.square().mul(t))).mul(FiniteFieldTools.sqrt(x2.pow(3L).add(this.b)));
            return this.groupImpl.getElement(x2, y);
        }
        if (i == 3) {
            FieldElement y = this.baseField.getElement(this.chi(r3.square().mul(t))).mul(FiniteFieldTools.sqrt(x3.pow(3L).add(this.b)));
            return this.groupImpl.getElement(x3, y);
        }
        throw new IllegalStateException("Unreachable!");
    }

    int chi(FieldElement t) {
        if (t.equals(this.baseField.getZeroElement())) {
            return 0;
        }
        if (FiniteFieldTools.isSquare(t)) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarretoNaehrigHashToSourceGroupImpl that = (BarretoNaehrigHashToSourceGroupImpl)o;
        return Objects.equals(this.groupImpl, that.groupImpl);
    }

    public int hashCode() {
        return Objects.hash(this.groupImpl, this.hashFunction1, this.hashFunction2);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }
}

