/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings;

import java.math.BigInteger;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.Ring;

public interface Field
extends Ring {
    public FieldElement getPrimitiveElement() throws UnsupportedOperationException;

    @Override
    default public BigInteger sizeUnitGroup() {
        return this.size() == null ? null : this.size().subtract(BigInteger.ONE);
    }

    @Override
    public FieldElement getZeroElement();

    @Override
    public FieldElement getOneElement();

    @Override
    public FieldElement restoreElement(Representation var1);

    @Override
    public FieldElement getElement(BigInteger var1);

    @Override
    default public FieldElement getElement(long i) {
        return this.getElement(BigInteger.valueOf(i));
    }

    @Override
    public FieldElement getUniformlyRandomElement() throws UnsupportedOperationException;

    @Override
    default public FieldElement getUniformlyRandomUnit() throws UnsupportedOperationException {
        try {
            FieldElement result;
            while (!(result = this.getUniformlyRandomElement()).isUnit()) {
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    default public boolean isCommutative() {
        return true;
    }
}

