/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.Ring;

public interface RingElement
extends Element {
    @Override
    public Ring getStructure();

    default public GroupElement toUnitGroupElement() {
        return RingGroup.unitGroupOf(this.getStructure()).getElement(this);
    }

    default public GroupElement toAdditiveGroupElement() {
        return RingGroup.additiveGroupOf(this.getStructure()).getElement(this);
    }

    public RingElement add(Element var1);

    public RingElement neg();

    default public RingElement sub(Element e) {
        return this.add(((RingElement)e).neg());
    }

    public RingElement mul(Element var1);

    default public RingElement mul(BigInteger k) {
        if (k.signum() < 0) {
            return this.mul(k.negate()).neg();
        }
        RingElement result = this.getStructure().getZeroElement();
        for (int i = k.bitLength() - 1; i >= 0; --i) {
            result = result.add(result);
            if (!k.testBit(i)) continue;
            result = result.add(this);
        }
        return result;
    }

    default public RingElement mul(long k) {
        return this.mul(BigInteger.valueOf(k));
    }

    default public RingElement pow(BigInteger k) {
        if (k.signum() < 0) {
            return this.pow(k.negate()).inv();
        }
        RingElement result = this.getStructure().getOneElement();
        for (int i = k.bitLength() - 1; i >= 0; --i) {
            result = result.mul(result);
            if (!k.testBit(i)) continue;
            result = result.mul(this);
        }
        return result;
    }

    default public RingElement pow(long k) {
        return this.pow(BigInteger.valueOf(k));
    }

    public RingElement inv() throws UnsupportedOperationException;

    default public boolean isUnit() {
        try {
            this.inv();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    default public RingElement div(Element e) throws IllegalArgumentException {
        return this.mul(((RingElement)e).inv());
    }

    public boolean divides(RingElement var1) throws UnsupportedOperationException;

    public RingElement[] divideWithRemainder(RingElement var1) throws UnsupportedOperationException, IllegalArgumentException;

    public BigInteger getRank() throws UnsupportedOperationException;

    default public boolean isZero() {
        return this.equals(this.getStructure().getZeroElement());
    }

    default public boolean isOne() {
        return this.equals(this.getStructure().getOneElement());
    }

    default public RingElement square() {
        return this.mul(this);
    }

    default public BigInteger asInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot interpret " + this.getClass().getName() + " as an integer");
    }
}

