/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.extfield;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cryptimeleon.math.misc.BigIntegerTools;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ExtensionField
implements Field {
    private FieldElement cubeRoot = null;
    protected FieldElement constant;
    protected int extensionDegree;
    protected PolynomialRing.Polynomial definingPolynomial;
    protected ExtensionFieldElement[] frobeniusOfXPowers;

    private void init(FieldElement constant, int extensionDegree) {
        int i;
        this.constant = constant;
        this.extensionDegree = extensionDegree;
        RingElement[] coefficients = new RingElement[extensionDegree + 1];
        coefficients[extensionDegree] = constant.getStructure().getOneElement();
        coefficients[0] = constant;
        for (i = 1; i < extensionDegree; ++i) {
            coefficients[i] = constant.getStructure().getZeroElement();
        }
        this.definingPolynomial = PolynomialRing.getPoly(coefficients);
        this.frobeniusOfXPowers = new ExtensionFieldElement[extensionDegree + 1];
        this.frobeniusOfXPowers[0] = this.getOneElement();
        if (extensionDegree > 0) {
            this.frobeniusOfXPowers[1] = (ExtensionFieldElement)this.createElement(constant.getStructure().getZeroElement(), constant.getStructure().getOneElement()).pow(this.getCharacteristic());
            for (i = 2; i < this.frobeniusOfXPowers.length; ++i) {
                this.frobeniusOfXPowers[i] = this.frobeniusOfXPowers[i - 1].mul(this.frobeniusOfXPowers[1]);
            }
        }
    }

    public ExtensionField(FieldElement constant, int extensionDegree) {
        this.init(constant, extensionDegree);
    }

    public ExtensionField(BigInteger p) {
        Zp baseField = new Zp(p);
        this.constant = baseField.getZeroElement();
        this.extensionDegree = 1;
        this.init(this.constant, this.extensionDegree);
    }

    public FieldElement getConstant() {
        return this.constant;
    }

    public boolean isBaseField() {
        return this.extensionDegree == 1;
    }

    @Override
    public Representation getRepresentation() {
        ObjectRepresentation o = new ObjectRepresentation();
        o.put("constant", this.constant.getRepresentation());
        o.put("extensionDegree", new BigIntegerRepresentation(this.extensionDegree));
        o.put("baseField", new RepresentableRepresentation(this.constant.getStructure()));
        return o;
    }

    public ExtensionField(Representation r) {
        ObjectRepresentation o = (ObjectRepresentation)r;
        Field baseField = (Field)((RepresentableRepresentation)o.get("baseField")).recreateRepresentable();
        this.init(baseField.restoreElement(o.get("constant")), BigIntegerTools.getExactInt(o.get("extensionDegree").bigInt().get()));
        if (o.get("cubeRoot") != null) {
            this.setCubeRoot(this.restoreElement(o.get("cubeRoot")));
        }
    }

    public FieldElement getCubeRoot() {
        if (this.cubeRoot == null) {
            this.generatePrimitiveCubeRoot();
        }
        return this.cubeRoot;
    }

    protected void setCubeRoot(FieldElement cubeRoot) {
        this.cubeRoot = cubeRoot;
    }

    public void generatePrimitiveCubeRoot() {
        FieldElement e;
        do {
            e = this.getUniformlyRandomElement();
        } while ((e = e.pow(this.size().subtract(BigInteger.ONE).divide(BigInteger.valueOf(3L)))).isOne());
        this.setCubeRoot(e);
    }

    public FieldElement[] reduce(FieldElement[] coefficients) {
        if (coefficients.length <= this.extensionDegree) {
            return coefficients;
        }
        FieldElement[] result = new FieldElement[this.extensionDegree];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getBaseField().getZeroElement();
        }
        FieldElement equivalence = this.getBaseField().getOneElement();
        int degree = 0;
        while (degree < coefficients.length) {
            int i = degree / this.extensionDegree;
            int j = degree % this.extensionDegree;
            FieldElement tmp = equivalence.mul(coefficients[degree]);
            result[j] = i % 2 == 0 ? result[j].add(tmp) : result[j].sub(tmp);
            if (++degree % this.extensionDegree != 0) continue;
            equivalence = equivalence.mul(this.constant);
        }
        return result;
    }

    public ExtensionFieldElement createElement(FieldElement ... coefficients) {
        return new ExtensionFieldElement(this, this.reduce(coefficients));
    }

    @Override
    public ExtensionFieldElement getElement(BigInteger i) {
        return this.createElement(this.constant.getStructure().getElement(i));
    }

    @Override
    public ExtensionFieldElement getElement(long i) {
        return this.getElement(BigInteger.valueOf(i));
    }

    @Override
    public double estimateCostInvPerOp() {
        return 0.3;
    }

    @Override
    public double estimateCostNegPerOp() {
        return this.constant.getStructure().estimateCostNegPerOp();
    }

    public ExtensionFieldElement createElement(BigInteger b) {
        ArrayList<BigInteger> pary = new ArrayList<BigInteger>();
        BigInteger a = b.abs();
        while (!a.equals(BigInteger.ZERO)) {
            BigInteger r = a.mod(this.getBaseField().size());
            a = a.subtract(r);
            a = a.divide(this.getBaseField().size());
            pary.add(r);
        }
        FieldElement[] coefficients = new FieldElement[pary.size()];
        int i = 0;
        for (BigInteger c : pary) {
            coefficients[i] = this.getBaseField() instanceof Zp ? ((Zp)this.getBaseField()).createZnElement(c) : ((ExtensionField)this.getBaseField()).createElement(c);
            ++i;
        }
        ExtensionFieldElement result = this.createElement(coefficients);
        if (b.compareTo(BigInteger.ZERO) < 0) {
            result = result.neg();
        }
        return result;
    }

    public String toString() {
        if (this.extensionDegree == 1) {
            return this.getBaseField().toString();
        }
        return "degree " + this.extensionDegree + " extension of " + this.getBaseField();
    }

    @Override
    public BigInteger sizeUnitGroup() throws UnsupportedOperationException {
        return this.size().subtract(BigInteger.ONE);
    }

    public Field getBaseField() {
        return this.constant.getStructure();
    }

    @Override
    public BigInteger getCharacteristic() throws UnsupportedOperationException {
        return this.getBaseField().getCharacteristic();
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.getBaseField().size().pow(this.extensionDegree);
    }

    @Override
    public FieldElement getPrimitiveElement() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public ExtensionFieldElement getZeroElement() {
        return this.createElement(this.getBaseField().getZeroElement());
    }

    @Override
    public ExtensionFieldElement getOneElement() {
        return this.createElement(this.getBaseField().getOneElement());
    }

    @Override
    public ExtensionFieldElement restoreElement(Representation repr) {
        ListRepresentation lr = (ListRepresentation)repr;
        FieldElement[] coefficients = new FieldElement[lr.size()];
        for (int i = 0; i < lr.size(); ++i) {
            coefficients[i] = this.getBaseField().restoreElement(lr.get(i));
        }
        return this.createElement(coefficients);
    }

    public ExtensionFieldElement createElement(List<BigInteger> coefficients) {
        FieldElement[] fes = new FieldElement[this.extensionDegree];
        for (int i = 0; i < this.extensionDegree; ++i) {
            Field baseField;
            if (this.getBaseField() instanceof ExtensionField) {
                baseField = (ExtensionField)this.getBaseField();
                fes[i] = ((ExtensionField)baseField).createElement(coefficients.subList(i * ((ExtensionField)baseField).extensionDegree, (i + 1) * ((ExtensionField)baseField).extensionDegree));
                continue;
            }
            if (this.getBaseField() instanceof Zp) {
                baseField = (Zp)this.getBaseField();
                if (coefficients.size() == 0) {
                    Field field = baseField;
                    field.getClass();
                    fes[i] = (Zp)field.new Zp.ZpElement(BigInteger.ZERO);
                    continue;
                }
                if (coefficients.size() == 1) {
                    Field field = baseField;
                    field.getClass();
                    fes[i] = (Zp)field.new Zp.ZpElement(coefficients.get(i));
                    continue;
                }
                throw new IllegalArgumentException("Not able to create ZpElement for list of size larger than 1.");
            }
            throw new RuntimeException("Creating elements from integer arrays is only supported for Zp base fields.");
        }
        return this.createElement(fes);
    }

    @Override
    public ExtensionFieldElement getUniformlyRandomElement() throws UnsupportedOperationException {
        FieldElement[] coefficients = new FieldElement[this.extensionDegree];
        for (int i = 0; i < this.extensionDegree; ++i) {
            coefficients[i] = this.getBaseField().getUniformlyRandomElement();
        }
        return this.createElement(coefficients);
    }

    public PolynomialRing.Polynomial getDefiningPolynomial() {
        return this.definingPolynomial;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        result = 31 * result + this.extensionDegree;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionField)) {
            return false;
        }
        ExtensionField other = (ExtensionField)obj;
        if (this.constant == null ? other.constant != null : !this.constant.equals(other.constant)) {
            return false;
        }
        return this.extensionDegree == other.extensionDegree;
    }

    public int getExtensionDegree() {
        return this.extensionDegree;
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.constant.getStructure().getUniqueByteLength().map(ubl -> ubl * (this.extensionDegree + 1));
    }
}

