/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.extfield;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;

public class ExtensionFieldElement
implements FieldElement,
UniqueByteRepresentable {
    private final ExtensionField field;
    private final FieldElement[] coefficients;

    public ExtensionFieldElement(ExtensionField f, FieldElement[] coefficients) {
        this.field = f;
        this.coefficients = (FieldElement[])coefficients.clone();
    }

    @Override
    public Representation getRepresentation() {
        ListRepresentation r = new ListRepresentation();
        for (FieldElement e : this.coefficients) {
            r.put(e.getRepresentation());
        }
        return r;
    }

    private static int[] minmax(int a, int b) {
        if (a < b) {
            return new int[]{a, b};
        }
        return new int[]{b, a};
    }

    @Override
    public ExtensionFieldElement add(Element e) {
        int i;
        FieldElement[] ec = ((ExtensionFieldElement)e).coefficients;
        int[] mima = ExtensionFieldElement.minmax(this.coefficients.length, ec.length);
        FieldElement[] result = new FieldElement[mima[1]];
        for (i = 0; i < mima[0]; ++i) {
            result[i] = ec[i].add(this.coefficients[i]);
        }
        while (i < this.coefficients.length) {
            result[i] = this.coefficients[i];
            ++i;
        }
        while (i < ec.length) {
            result[i] = ec[i];
            ++i;
        }
        return this.getStructure().createElement(result);
    }

    @Override
    public ExtensionFieldElement neg() {
        FieldElement[] result = new FieldElement[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            result[i] = this.coefficients[i].neg();
        }
        return this.getStructure().createElement(result);
    }

    @Override
    public ExtensionFieldElement mul(Element e) {
        ExtensionFieldElement other = (ExtensionFieldElement)e;
        Object[] result = new FieldElement[this.field.extensionDegree];
        Arrays.fill(result, this.field.getBaseField().getZeroElement());
        for (int i = 0; i < this.coefficients.length; ++i) {
            FieldElement coefficient = this.coefficients[i];
            for (int j = 0; j < other.coefficients.length; ++j) {
                if (i + j < this.field.extensionDegree) {
                    result[i + j] = result[i + j].add(coefficient.mul(other.coefficients[j]));
                    continue;
                }
                result[i + j - this.field.extensionDegree] = result[i + j - this.field.extensionDegree].sub(coefficient.mul(other.coefficients[j]).mul(this.field.constant));
            }
        }
        return this.field.createElement((FieldElement[])result);
    }

    public FieldElement[] getCoefficients() {
        return this.coefficients;
    }

    @Override
    public ExtensionFieldElement inv() throws UnsupportedOperationException {
        PolynomialRing.Polynomial poly = PolynomialRing.getPoly(this.coefficients);
        PolynomialRing polyRing = poly.getStructure();
        RingElement[] eeaResult = polyRing.extendedEuclideanAlgorithm(poly, this.field.getDefiningPolynomial());
        PolynomialRing.Polynomial inversePoly = (PolynomialRing.Polynomial)eeaResult[0].mul(eeaResult[2].inv());
        return this.getStructure().createElement((FieldElement[])Arrays.copyOf(inversePoly.getCoefficients(), inversePoly.getCoefficients().length, FieldElement[].class));
    }

    public ExtensionFieldElement conjugate() {
        if (this.getStructure().isBaseField()) {
            return this;
        }
        if (this.getStructure().getExtensionDegree() == 2) {
            FieldElement[] coefficients = new FieldElement[this.coefficients.length];
            for (int i = 0; i < this.coefficients.length; ++i) {
                coefficients[i] = i % 2 == 0 ? (ExtensionFieldElement)this.coefficients[i] : (ExtensionFieldElement)this.coefficients[i].neg();
            }
            return this.getStructure().createElement(coefficients);
        }
        throw new UnsupportedOperationException("Conjugation only supported for extension degree 1 and 2.");
    }

    @Override
    public ExtensionFieldElement applyFrobenius() {
        ExtensionFieldElement result = this.getStructure().getZeroElement();
        for (int i = 0; i < this.coefficients.length; ++i) {
            result = result.add(this.field.createElement(this.coefficients[i].applyFrobenius()).mul(this.getStructure().frobeniusOfXPowers[i]));
        }
        return result;
    }

    @Override
    public ExtensionField getStructure() {
        return this.field;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionFieldElement)) {
            return false;
        }
        ExtensionFieldElement other = (ExtensionFieldElement)obj;
        int[] mm = ExtensionFieldElement.minmax(this.coefficients.length, other.coefficients.length);
        for (i = 0; i < mm[0]; ++i) {
            if (this.coefficients[i].equals(other.coefficients[i])) continue;
            return false;
        }
        for (i = mm[0]; i < this.coefficients.length; ++i) {
            if (this.coefficients[i].isZero()) continue;
            return false;
        }
        for (i = mm[0]; i < other.coefficients.length; ++i) {
            if (other.coefficients[i].isZero()) continue;
            return false;
        }
        return true;
    }

    public ExtensionFieldElement reduce() {
        return this;
    }

    public String toString() {
        if (this.field.extensionDegree == 1) {
            return this.coefficients[0].toString();
        }
        return "[" + Arrays.stream(this.coefficients).map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        int i;
        Consumer<UniqueByteRepresentable> accumulationMethod = !this.field.getUniqueByteLength().isPresent() ? accumulator::escapeAndSeparate : accumulator::append;
        for (i = 0; i < this.coefficients.length; ++i) {
            accumulationMethod.accept(this.coefficients[i]);
        }
        for (i = this.coefficients.length; i <= this.field.getExtensionDegree(); ++i) {
            accumulationMethod.accept(this.field.getConstant().getStructure().getZeroElement());
        }
        return accumulator;
    }

    @Override
    public BigInteger asInteger() throws UnsupportedOperationException {
        if (this.coefficients.length == 0) {
            return BigInteger.ZERO;
        }
        for (int i = 1; i < this.coefficients.length; ++i) {
            if (this.coefficients[i].isZero()) continue;
            throw new UnsupportedOperationException("No integer value for " + this);
        }
        return this.coefficients[0].asInteger();
    }
}

