/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.hash.impl.SHA512HashFunction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashFunctionTest {
    private HashFunction function;

    public HashFunctionTest(HashFunction function) {
        this.function = function;
    }

    @Test
    public void checkForCorrectness() {
        String testString = "IAMATEST";
        String testString2 = "IAMATEST";
        byte[] hash1 = this.function.hash(testString);
        byte[] hash2 = this.function.hash(testString2);
        Assert.assertArrayEquals((byte[])hash1, (byte[])hash2);
    }

    @Test
    public void checkEscapedBytes() {
        String testString = "IAMA\tEST";
        String testString2 = "IAMAtEST";
        byte[] hash1 = this.function.hash(testString);
        byte[] hash2 = this.function.hash(testString2);
        Assert.assertFalse((boolean)Arrays.equals(hash1, hash2));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<HashFunction> getParams() {
        ArrayList<HashFunction> list = new ArrayList<HashFunction>();
        list.add((HashFunction)new SHA256HashFunction());
        list.add((HashFunction)new SHA512HashFunction());
        return list;
    }
}

