/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.random;

import java.math.BigInteger;
import java.util.Arrays;
import org.cryptimeleon.math.random.SecureRandomGeneratorImpl;
import org.junit.Assert;
import org.junit.Test;

public class RNGTest {
    @Test
    public void testBigInteger() {
        SecureRandomGeneratorImpl rng = new SecureRandomGeneratorImpl();
        System.out.println("Test RNG for integers.");
        for (int size = 1; size <= 16; ++size) {
            System.out.println("size:" + size);
            for (int offset = -1; offset <= 1; ++offset) {
                BigInteger range = BigInteger.ONE.shiftLeft(size).add(BigInteger.valueOf(offset));
                for (int i = 0; i < 100; ++i) {
                    BigInteger r = rng.getRandomNumber(range);
                    Assert.assertTrue((range.compareTo(r) > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((r.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testDistribution() {
        SecureRandomGeneratorImpl rng = new SecureRandomGeneratorImpl();
        System.out.println("Test distribution of generated numbers");
        int[] ranges = new int[]{255, 256, 257};
        int k = 100000;
        for (int n : ranges) {
            int[] buckets = new int[n];
            for (int i = 0; i < k; ++i) {
                int n2 = rng.getRandomNumber(BigInteger.valueOf(n)).intValue();
                buckets[n2] = buckets[n2] + 1;
            }
            Arrays.sort(buckets);
            Assert.assertTrue((buckets[0] > k / n - 200 ? 1 : 0) != 0);
            Assert.assertTrue((buckets[buckets.length - 1] < k / n + 200 ? 1 : 0) != 0);
        }
    }
}

