/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class RepresentedEnumParams {

    public static class RepresentedEnum
    implements StandaloneRepresentable {
        @Represented
        RepresentableEnum testEnum;
        @Represented
        RepresentableEnum nullValue;
        @Represented
        RepresentableEnum[] enumArray;
        @Represented
        List<RepresentableEnum> enumList;
        @Represented
        Set<RepresentableEnum> enumSet;
        @Represented
        Map<RepresentableEnum, RepresentableEnum> enumMap;

        public RepresentedEnum() {
            this.testEnum = RepresentableEnum.ENUM_VALUE1;
            this.nullValue = null;
            this.enumArray = RepresentableEnum.values();
            this.enumList = new ArrayList<RepresentableEnum>(Arrays.asList(RepresentableEnum.values()));
            this.enumSet = new HashSet<RepresentableEnum>(Arrays.asList(RepresentableEnum.values()));
            this.enumMap = new HashMap(Arrays.stream(RepresentableEnum.values()).collect(Collectors.toMap(Function.identity(), Function.identity())));
        }

        public RepresentedEnum(Representation representation) {
            new ReprUtil((Object)this).deserialize(representation);
        }

        public Representation getRepresentation() {
            return ReprUtil.serialize((Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepresentedEnum that = (RepresentedEnum)o;
            return this.testEnum == that.testEnum && this.nullValue == that.nullValue && Arrays.equals((Object[])this.enumArray, (Object[])that.enumArray) && Objects.equals(this.enumList, that.enumList) && Objects.equals(this.enumSet, that.enumSet) && Objects.equals(this.enumMap, that.enumMap);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.testEnum, this.nullValue, this.enumList, this.enumSet, this.enumMap});
            result = 31 * result + Arrays.hashCode((Object[])this.enumArray);
            return result;
        }
    }

    public static enum RepresentableEnum {
        ENUM_VALUE1,
        ENUM_VALUE2,
        ENUM_VALUE3;

    }
}

