/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class CountingTest {
    DebugBilinearGroup bilGroup;

    @Before
    public void setUp() {
        this.bilGroup = new DebugBilinearGroup(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_2);
    }

    @Test
    public void testNullInstantiation() {
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        String bucketName = this.getClass().getName() + "#testNullInstantiation";
        this.bilGroup.setBucket(bucketName);
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumRetrievedRepresentations(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumExps(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumSquaringsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumInversionsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumOpsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumSquaringsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)0L, (long)debugGroup.getNumInversionsNoExpMultiExp(bucketName));
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])debugGroup.getMultiExpTermNumbers(bucketName).toArray(new Integer[0]));
    }

    @Test
    public void testBasicOperationCounting() {
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        String bucketName = this.getClass().getName() + "#testBasicOperationCounting";
        this.bilGroup.setBucket(bucketName);
        GroupElement elem = debugGroup.getUniformlyRandomNonNeutral();
        GroupElement elem2 = debugGroup.getUniformlyRandomNonNeutral();
        elem.op((Element)elem).inv().computeSync();
        elem.op((Element)elem2).computeSync();
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumOpsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumInversionsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumInversionsTotal(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumSquaringsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumSquaringsTotal(bucketName));
    }

    @Test
    public void testPowCounting() {
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        String bucketName = this.getClass().getName() + "#testPowCounting";
        this.bilGroup.setBucket(bucketName);
        GroupElement elem = debugGroup.getUniformlyRandomNonNeutral();
        elem.pow(10L).computeSync();
        Assertions.assertEquals((long)8L, (long)debugGroup.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)2L, (long)debugGroup.getNumSquaringsTotal(bucketName));
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumExps(bucketName));
    }

    @Test
    public void testRepresentationCounting() {
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        String bucketName = this.getClass().getName() + "#testRepresentationCounting";
        this.bilGroup.setBucket(bucketName);
        GroupElement elem = debugGroup.getUniformlyRandomNonNeutral();
        elem.getRepresentation();
        elem.getRepresentation();
        Assertions.assertEquals((long)2L, (long)debugGroup.getNumRetrievedRepresentations(bucketName));
    }

    @Test
    public void testPairingCounting() {
        String bucketName = this.getClass().getName() + "#testPairingCounting";
        this.bilGroup.setBucket(bucketName);
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        DebugGroup groupGT = (DebugGroup)this.bilGroup.getGT();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2).computeSync();
        Assertions.assertEquals((long)1L, (long)this.bilGroup.getNumPairings(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumExps(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG2.getNumExps(bucketName));
        Assertions.assertEquals((long)0L, (long)groupGT.getNumExps(bucketName));
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        Assertions.assertEquals((long)2L, (long)this.bilGroup.getNumPairings(bucketName));
        Assertions.assertEquals((long)8L, (long)groupGT.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)2L, (long)groupGT.getNumSquaringsTotal(bucketName));
        Assertions.assertEquals((long)1L, (long)groupGT.getNumExps(bucketName));
    }

    @Test
    public void testMultiExpCounting() {
        GroupElement elem3;
        GroupElement elem2;
        GroupElement elem1;
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        String bucketName = this.getClass().getName() + "#testMultiExpCounting";
        this.bilGroup.setBucket(bucketName);
        do {
            elem1 = debugGroup.getUniformlyRandomNonNeutral();
            elem2 = debugGroup.getUniformlyRandomNonNeutral();
            elem3 = debugGroup.getUniformlyRandomNonNeutral();
        } while (elem1.equals(elem2) || elem2.equals(elem3) || elem3.equals(elem1));
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        Assertions.assertArrayEquals((Object[])new Integer[]{3}, (Object[])debugGroup.getMultiExpTermNumbers(bucketName).toArray(new Integer[1]));
        Assertions.assertEquals((long)24L, (long)debugGroup.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)4L, (long)debugGroup.getNumSquaringsTotal(bucketName));
    }

    @Test
    public void testComputeWorksSynchronously() {
        String bucketName = this.getClass().getName() + "#testComputeWorksSynchronously";
        this.bilGroup.setBucket(bucketName);
        DebugGroup debugGroup = (DebugGroup)this.bilGroup.getG1();
        GroupElement elem = debugGroup.getUniformlyRandomNonNeutral();
        elem.op((Element)elem).inv().compute();
        Assertions.assertEquals((long)1L, (long)debugGroup.getNumSquaringsNoExpMultiExp(bucketName));
    }

    @Test
    public void testResetCounters() {
        String bucketName = this.getClass().getName() + "#testResetCounters";
        this.bilGroup.setBucket(bucketName);
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        GroupElement elem1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem2 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem3 = groupG1.getUniformlyRandomNonNeutral();
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        elem1.op((Element)elem2).inv().computeSync();
        elem1.getRepresentation();
        this.bilGroup.resetCounters(bucketName);
        Assertions.assertEquals((long)0L, (long)groupG1.getNumRetrievedRepresentations(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumExps(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumOpsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumSquaringsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumInversionsTotal(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumOpsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumSquaringsNoExpMultiExp(bucketName));
        Assertions.assertEquals((long)0L, (long)groupG1.getNumInversionsNoExpMultiExp(bucketName));
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])groupG1.getMultiExpTermNumbers(bucketName).toArray(new Integer[0]));
        Assertions.assertEquals((long)0L, (long)this.bilGroup.getNumPairings(bucketName));
    }

    @Test
    public void testCountingHomomorphism() {
        String bucketName = this.getClass().getName() + "#testCountingHomomorphism";
        this.bilGroup.setBucket(bucketName);
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        GroupElement elemG1 = (GroupElement)this.bilGroup.getHomomorphismG2toG1().apply((Object)elemG2);
        Assertions.assertEquals((Object)elemG1.getStructure(), (Object)groupG1);
    }

    @Test
    public void testAllBuckets() {
        this.bilGroup.resetCountersAllBuckets();
        String bucketName1 = this.getClass().getName() + "#testAllBuckets(1)";
        String bucketName2 = this.getClass().getName() + "#testAllBuckets(2)";
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        DebugGroup groupGT = (DebugGroup)this.bilGroup.getGT();
        this.bilGroup.setBucket(bucketName1);
        GroupElement elem1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem2 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem3 = groupG1.getUniformlyRandomNonNeutral();
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        elem1.op((Element)elem2).inv().computeSync();
        elem1.getRepresentation();
        this.bilGroup.setBucket(bucketName2);
        elem1 = groupG1.getUniformlyRandomNonNeutral();
        elem2 = groupG1.getUniformlyRandomNonNeutral();
        elem3 = groupG1.getUniformlyRandomNonNeutral();
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        elemG1 = groupG1.getUniformlyRandomNonNeutral();
        elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        elem1.op((Element)elem2).inv().computeSync();
        elem1.getRepresentation();
        Assertions.assertEquals((long)2L, (long)groupG1.getNumRetrievedRepresentationsAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumExpsAllBuckets());
        Assertions.assertEquals((long)50L, (long)groupG1.getNumOpsTotalAllBuckets());
        Assertions.assertEquals((long)8L, (long)groupG1.getNumSquaringsTotalAllBuckets());
        Assertions.assertEquals((long)2L, (long)groupG1.getNumInversionsTotalAllBuckets());
        Assertions.assertEquals((long)2L, (long)groupG1.getNumOpsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumSquaringsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)2L, (long)groupG1.getNumInversionsNoExpMultiExpAllBuckets());
        Assertions.assertArrayEquals((Object[])new Integer[]{3, 3}, (Object[])groupG1.getMultiExpTermNumbersAllBuckets().toArray(new Integer[0]));
        Assertions.assertEquals((long)0L, (long)groupG2.getNumRetrievedRepresentationsAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumExpsAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumOpsTotalAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumSquaringsTotalAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumInversionsTotalAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumOpsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumSquaringsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumInversionsNoExpMultiExpAllBuckets());
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])groupG2.getMultiExpTermNumbersAllBuckets().toArray(new Integer[0]));
        Assertions.assertEquals((long)0L, (long)groupGT.getNumRetrievedRepresentationsAllBuckets());
        Assertions.assertEquals((long)2L, (long)groupGT.getNumExpsAllBuckets());
        Assertions.assertEquals((long)16L, (long)groupGT.getNumOpsTotalAllBuckets());
        Assertions.assertEquals((long)4L, (long)groupGT.getNumSquaringsTotalAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupGT.getNumInversionsTotalAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupGT.getNumOpsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupGT.getNumSquaringsNoExpMultiExpAllBuckets());
        Assertions.assertEquals((long)0L, (long)groupGT.getNumInversionsNoExpMultiExpAllBuckets());
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])groupGT.getMultiExpTermNumbersAllBuckets().toArray(new Integer[0]));
        Assertions.assertEquals((long)2L, (long)this.bilGroup.getNumPairingsAllBuckets());
    }

    @Test
    public void testStaticCounting() {
        DebugGroup debug1 = new DebugGroup("DG1", 1000000L);
        DebugGroup debug2 = new DebugGroup("DG2", 1000000L);
        String bucketName = "#testStaticCounting";
        debug1.setBucket(bucketName);
        debug2.setBucket(bucketName);
        GroupElement elem1 = debug1.getUniformlyRandomNonNeutral();
        GroupElement elem2 = debug2.getUniformlyRandomNonNeutral();
        elem1.op((Element)elem1).compute();
        elem2.op((Element)elem2).compute();
        Assertions.assertEquals((long)2L, (long)debug1.getNumSquaringsTotal(bucketName));
        Assertions.assertEquals((long)2L, (long)debug2.getNumSquaringsTotal(bucketName));
    }

    @Test
    public void testSeparateBuckets() {
        String bucketName1 = this.getClass().getName() + "#testSeparateBuckets(1)";
        String bucketName2 = this.getClass().getName() + "#testSeparateBuckets(2)";
        DebugGroup debug1 = new DebugGroup("DG1", 1000000L);
        GroupElement elem1 = debug1.getUniformlyRandomNonNeutral();
        debug1.setBucket(bucketName1);
        elem1.op((Element)elem1).compute();
        debug1.setBucket(bucketName2);
        elem1.op((Element)elem1).compute();
        Assertions.assertEquals((long)1L, (long)debug1.getNumSquaringsTotal(bucketName1));
        Assertions.assertEquals((long)1L, (long)debug1.getNumSquaringsTotal(bucketName2));
    }

    @Test
    public void testStaticPairingCounting() {
        String bucketName = this.getClass().getName() + "#testStaticPairingCounting";
        DebugBilinearGroup bilGroup1 = new DebugBilinearGroup(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_2);
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        DebugGroup groupG11 = (DebugGroup)bilGroup1.getG1();
        DebugGroup groupG21 = (DebugGroup)bilGroup1.getG2();
        GroupElement elemG11 = groupG11.getUniformlyRandomNonNeutral();
        GroupElement elemG21 = groupG21.getUniformlyRandomNonNeutral();
        this.bilGroup.setBucket(bucketName);
        bilGroup1.setBucket(bucketName);
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2).computeSync();
        bilGroup1.getBilinearMap().apply(elemG11, elemG21).computeSync();
        Assertions.assertEquals((long)2L, (long)this.bilGroup.getNumPairings(bucketName));
        Assertions.assertEquals((long)2L, (long)bilGroup1.getNumPairings(bucketName));
    }

    @Test
    public void testSeparateBucketsPairingCounting() {
        String bucketName1 = this.getClass().getName() + "#testSeparateBucketsPairingCounting(1)";
        String bucketName2 = this.getClass().getName() + "#testSeparateBucketsPairingCounting(2)";
        DebugGroup groupG1 = (DebugGroup)this.bilGroup.getG1();
        DebugGroup groupG2 = (DebugGroup)this.bilGroup.getG2();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.setBucket(bucketName1);
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2).computeSync();
        this.bilGroup.setBucket(bucketName2);
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2).computeSync();
        Assertions.assertEquals((long)1L, (long)this.bilGroup.getNumPairings(bucketName1));
        Assertions.assertEquals((long)1L, (long)this.bilGroup.getNumPairings(bucketName2));
    }
}

