/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.cryptimeleon.math.hash.EscapingByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;

public abstract class ByteAccumulator
implements Comparable<ByteAccumulator> {
    public static byte SEPARATOR = (byte)92;

    public abstract void append(byte[] var1);

    public abstract byte[] extractBytes();

    public void appendAndSeparate(byte[] bytes) {
        this.append(bytes);
        this.appendSeperator();
    }

    public void appendAndSeparate(String str) {
        this.appendAndSeparate(str.getBytes(StandardCharsets.UTF_8));
    }

    public void escapeAndAppend(byte[] bytes) {
        new EscapingByteAccumulator(this).append(bytes);
    }

    public void escapeAndAppend(String str) {
        this.escapeAndAppend(str.getBytes(StandardCharsets.UTF_8));
    }

    public void escapeAndAppend(UniqueByteRepresentable ubr) {
        new EscapingByteAccumulator(this).append(ubr);
    }

    public void escapeAndSeparate(byte[] bytes) {
        this.escapeAndAppend(bytes);
        this.appendSeperator();
    }

    public void escapeAndSeparate(String str) {
        this.escapeAndSeparate(str.getBytes(StandardCharsets.UTF_8));
    }

    public void escapeAndSeparate(UniqueByteRepresentable ubr) {
        this.escapeAndAppend(ubr);
        this.appendSeperator();
    }

    public void appendSeperator() {
        this.append(new byte[]{SEPARATOR});
    }

    public void appendPadded(int length, byte[] bytes) {
        if (length < bytes.length) {
            throw new IllegalArgumentException("The bytes have a longer length than specified!");
        }
        byte[] paddedBytes = new byte[length];
        System.arraycopy(bytes, 0, paddedBytes, 0, bytes.length);
        for (int i = bytes.length; i < length; ++i) {
            paddedBytes[i] = 0;
        }
        this.append(paddedBytes);
    }

    public void append(UniqueByteRepresentable ubr) {
        this.append(ubr.getUniqueByteRepresentation());
    }

    public void append(byte singleByte) {
        this.append(new byte[]{singleByte});
    }

    public void append(int integer) {
        this.append(ByteBuffer.allocate(4).putInt(integer).array());
    }

    public void append(String str) {
        this.append(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int compareTo(ByteAccumulator byteAccumulator) {
        byte[] thisArr = this.extractBytes();
        byte[] theirArr = byteAccumulator.extractBytes();
        for (int i = 0; i < Math.min(thisArr.length, theirArr.length); ++i) {
            if (thisArr[i] == theirArr[i]) continue;
            return thisArr[i] < theirArr[i] ? -1 : 1;
        }
        return Integer.compare(thisArr.length, theirArr.length);
    }
}

