/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.AbstractEllipticCurvePoint;
import org.cryptimeleon.math.structures.groups.elliptic.EllipticCurvePoint;
import org.cryptimeleon.math.structures.groups.elliptic.WeierstrassCurve;
import org.cryptimeleon.math.structures.rings.FieldElement;

public class AffineEllipticCurvePoint
extends AbstractEllipticCurvePoint {
    public AffineEllipticCurvePoint(WeierstrassCurve curve, FieldElement x, FieldElement y) {
        super(curve, x, y, curve.getFieldOfDefinition().getOneElement());
    }

    public AffineEllipticCurvePoint(WeierstrassCurve curve) {
        super(curve, curve.getFieldOfDefinition().getZeroElement(), curve.getFieldOfDefinition().getOneElement(), curve.getFieldOfDefinition().getZeroElement());
    }

    public AffineEllipticCurvePoint(WeierstrassCurve curve, Representation repr) {
        super(curve, repr);
    }

    @Override
    public AffineEllipticCurvePoint normalize() {
        return this;
    }

    @Override
    public GroupElementImpl inv() {
        if (this.isNeutralElement()) {
            return this;
        }
        FieldElement y = this.getY();
        y = this.getStructure().isShortForm() ? y.neg() : y.add(this.getStructure().getA1().mul(this.getX())).add(this.getStructure().getA3()).neg();
        return this.getStructure().getElement(this.getX(), y);
    }

    private FieldElement calculateLambda(EllipticCurvePoint Q) {
        FieldElement denominator;
        FieldElement enumerator;
        AffineEllipticCurvePoint P = (AffineEllipticCurvePoint)Q;
        if (this.getX().equals(P.getX())) {
            FieldElement x = this.getX();
            FieldElement y = this.getY();
            enumerator = x.mul(x);
            enumerator = enumerator.add(enumerator).add(enumerator);
            FieldElement tmp = this.getStructure().getA2().mul(x);
            tmp = tmp.add(tmp);
            enumerator = enumerator.add(tmp);
            enumerator = enumerator.add(this.getStructure().getA4()).sub(y.mul(this.getStructure().getA1()));
            denominator = y.add(y);
            denominator = denominator.add(x.mul(this.getStructure().getA1()));
            denominator = denominator.add(this.getStructure().getA3());
        } else {
            enumerator = P.getY().sub(this.getY());
            denominator = P.getX().sub(this.getX());
        }
        return enumerator.div(denominator);
    }

    private FieldElement calculateNu(AffineEllipticCurvePoint P) {
        FieldElement denominator;
        FieldElement enumerator;
        FieldElement x = this.getX();
        FieldElement y = this.getY();
        if (this.getX().equals(P.getX())) {
            enumerator = x.mul(x).mul(x).neg();
            enumerator = enumerator.add(x.mul(this.getStructure().getA4()));
            enumerator = enumerator.add(this.getStructure().getA6()).add(this.getStructure().getA6());
            enumerator = enumerator.sub(y.mul(this.getStructure().getA3()));
            denominator = y.add(y);
            denominator = denominator.add(x.mul(this.getStructure().getA1()));
            denominator = denominator.add(this.getStructure().getA3());
        } else {
            enumerator = y.mul(P.getX()).sub(P.getY().mul(x));
            denominator = P.getX().sub(x);
        }
        return enumerator.div(denominator);
    }

    @Override
    public AffineEllipticCurvePoint add(EllipticCurvePoint P, FieldElement[] line) {
        AffineEllipticCurvePoint Q = (AffineEllipticCurvePoint)P;
        if (Q.isNeutralElement()) {
            return this;
        }
        if (this.isNeutralElement()) {
            return Q;
        }
        if (line[0].isZero()) {
            return (AffineEllipticCurvePoint)this.getStructure().getNeutralElement();
        }
        FieldElement nu = this.getStructure().isShortForm() ? this.getStructure().getFieldOfDefinition().getZeroElement() : this.calculateNu(Q);
        FieldElement lambda = line[1];
        FieldElement x = lambda.mul(lambda).add(lambda.mul(this.getStructure().getA1())).sub(this.getStructure().getA2()).sub(this.getX()).sub(Q.getX());
        FieldElement y = this.getStructure().isShortForm() ? this.getX().sub(x).mul(lambda).sub(this.getY()) : lambda.add(this.getStructure().getA1()).neg().mul(x).sub(nu).sub(this.getStructure().getA3());
        return (AffineEllipticCurvePoint)this.getStructure().getElement(x, y);
    }

    @Override
    public FieldElement[] computeLine(EllipticCurvePoint Q) {
        AffineEllipticCurvePoint P = (AffineEllipticCurvePoint)Q;
        if (this.equals(P.inv()) || this.isNeutralElement() || P.isNeutralElement()) {
            return new FieldElement[]{this.getFieldOfDefinition().getZeroElement(), this.getFieldOfDefinition().getOneElement()};
        }
        return new FieldElement[]{this.getFieldOfDefinition().getOneElement(), this.calculateLambda(P)};
    }

    public boolean equals(Object element) {
        if (element == this) {
            return true;
        }
        if (!(element instanceof AffineEllipticCurvePoint)) {
            return false;
        }
        AffineEllipticCurvePoint p = (AffineEllipticCurvePoint)element;
        if (this.isNeutralElement() && p.isNeutralElement()) {
            return true;
        }
        if (this.isNeutralElement() || p.isNeutralElement()) {
            return false;
        }
        if (!this.getX().equals(p.getX())) {
            return false;
        }
        return this.getY().equals(p.getY());
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        AffineEllipticCurvePoint normalized = this.normalize();
        if (!this.getStructure().getFieldOfDefinition().getUniqueByteLength().isPresent()) {
            accumulator.escapeAndSeparate(normalized.getX());
            accumulator.escapeAndSeparate(normalized.getY());
            accumulator.escapeAndSeparate(normalized.getZ());
        } else {
            accumulator.append(normalized.getX());
            accumulator.append(normalized.getY());
            accumulator.append(normalized.getZ());
        }
        return accumulator;
    }
}

