/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.standalone.params;

import java.math.BigInteger;
import java.util.Random;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.prf.aes.AesPseudorandomFunction;
import org.cryptimeleon.math.prf.aes.LongAesPseudoRandomFunction;
import org.cryptimeleon.math.prf.zn.HashThenPrfToZn;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class PrfStandaloneReprTests
extends StandaloneReprSubTest {
    public void testAes() {
        this.test((StandaloneRepresentable)new AesPseudorandomFunction(128));
    }

    public void testLongAes() {
        this.test((StandaloneRepresentable)new LongAesPseudoRandomFunction(new AesPseudorandomFunction(128), 9));
    }

    public void testAesToZn() {
        BigInteger p = BigInteger.probablePrime(400, new Random());
        Zn zn = new Zn(p);
        this.test((StandaloneRepresentable)new HashThenPrfToZn(128, zn, (HashFunction)new SHA256HashFunction(), 64));
    }
}

