/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentMulExpr
implements ExponentExpr {
    protected final ExponentExpr lhs;
    protected final ExponentExpr rhs;

    public ExponentMulExpr(ExponentExpr lhs, ExponentExpr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public ExponentExpr getLhs() {
        return this.lhs;
    }

    public ExponentExpr getRhs() {
        return this.rhs;
    }

    @Override
    public BigInteger evaluate() {
        return this.lhs.evaluate().multiply(this.rhs.evaluate());
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return this.lhs.evaluate(zn).mul(this.rhs.evaluate(zn));
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).mul(this.rhs.substitute(substitutions));
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        boolean lhsHasVariables = this.lhs.containsVariables();
        boolean rhsHasVariables = this.rhs.containsVariables();
        if (lhsHasVariables && rhsHasVariables) {
            throw new IllegalArgumentException("Expression is not linear (it's of the form a*b where both a and b depend on variables)");
        }
        if (!lhsHasVariables && !rhsHasVariables) {
            return new ExponentSumExpr(this, new ExponentEmptyExpr());
        }
        if (lhsHasVariables) {
            ExponentSumExpr lhsLinearized = this.lhs.linearize();
            return new ExponentSumExpr(lhsLinearized.getLhs().mul(this.rhs), lhsLinearized.getRhs().mul(this.rhs));
        }
        ExponentSumExpr rhsLinearized = this.rhs.linearize();
        return new ExponentSumExpr(this.lhs.mul(rhsLinearized.getLhs()), this.lhs.mul(rhsLinearized.getRhs()));
    }
}

