/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.misc;

import java.util.Arrays;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.prf.PrfImage;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.PrfPreimage;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class ByteArrayImpl
implements PrfKey,
PrfPreimage,
PrfImage {
    @Represented
    protected byte[] data;

    public ByteArrayImpl(byte[] bytes) {
        this.data = bytes;
    }

    public ByteArrayImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    public static ByteArrayImpl fromRandom(int numberBytes) {
        return new ByteArrayImpl(RandomGenerator.getRandomBytes(numberBytes));
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteArrayImpl append(ByteArrayImpl a) {
        byte[] result = new byte[this.data.length + a.getData().length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        System.arraycopy(a.data, 0, result, this.data.length, a.getData().length);
        return new ByteArrayImpl(result);
    }

    public ByteArrayImpl substring(int firstIndex, int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.data, firstIndex, result, 0, length);
        return new ByteArrayImpl(result);
    }

    public int length() {
        return this.data.length;
    }

    public ByteArrayImpl xor(ByteArrayImpl a) {
        int min = Math.min(this.length(), a.length());
        int max = Math.max(this.length(), a.length());
        byte[] result = new byte[max];
        for (int i = 0; i < min; ++i) {
            result[i] = (byte)(this.getData()[i] ^ a.getData()[i]);
        }
        return new ByteArrayImpl(result);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayImpl other = (ByteArrayImpl)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < this.getData().length; ++i) {
            result.append(String.format("%d", Byte.toUnsignedInt(this.getData()[i])));
            if (i >= this.getData().length - 1) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.append(this.data);
        return accumulator;
    }
}

