/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.prf;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.prf.PrfImage;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.PrfPreimage;
import org.cryptimeleon.math.prf.PseudorandomFunction;
import org.cryptimeleon.math.prf.aes.AesPseudorandomFunction;
import org.cryptimeleon.math.prf.aes.LongAesPseudoRandomFunction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PrfTest {
    private PseudorandomFunction prf;
    private Supplier<PrfPreimage> preimageSupplier;

    public PrfTest(TestParams params) {
        this.prf = params.prf;
        this.preimageSupplier = params.preimageSupplier;
    }

    @Test
    public void testRun() {
        PrfKey k = this.prf.generateKey();
        Assert.assertNotNull((Object)this.prf.evaluate(k, this.preimageSupplier.get()));
    }

    @Test
    public void testSerialization() {
        PrfKey k = this.prf.generateKey();
        Assert.assertEquals((Object)k, (Object)this.prf.restoreKey(k.getRepresentation()));
        PrfPreimage x = this.preimageSupplier.get();
        Assert.assertEquals((Object)x, (Object)this.prf.restorePreimage(x.getRepresentation()));
        PrfImage y = this.prf.evaluate(k, x);
        Assert.assertEquals((Object)y, (Object)this.prf.restoreImage(y.getRepresentation()));
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        AesPseudorandomFunction aes = new AesPseudorandomFunction(128);
        LongAesPseudoRandomFunction longAes = new LongAesPseudoRandomFunction(aes, 7);
        TestParams[][] params = new TestParams[][]{{new TestParams((PseudorandomFunction)aes, () -> ByteArrayImpl.fromRandom((int)16))}, {new TestParams((PseudorandomFunction)longAes, () -> ByteArrayImpl.fromRandom((int)16))}};
        return Arrays.asList(params);
    }

    private static class TestParams {
        private PseudorandomFunction prf;
        private Supplier<PrfPreimage> preimageSupplier;

        public TestParams(PseudorandomFunction prf, Supplier<PrfPreimage> preimageSupplier) {
            this.prf = prf;
            this.preimageSupplier = preimageSupplier;
        }

        public String toString() {
            return this.prf.getClass().getName() + " - " + this.prf.toString();
        }
    }
}

