/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.converter;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ByteArrayRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.MapRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.serialization.converter.BinaryFormatConverter;
import org.cryptimeleon.math.serialization.converter.Converter;
import org.cryptimeleon.math.serialization.converter.JSONConverter;
import org.cryptimeleon.math.serialization.converter.JSONPrettyConverter;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConverterTest {
    protected Converter converter;
    protected static final BigIntegerRepresentation five = new BigIntegerRepresentation(5L);
    protected static final BigIntegerRepresentation twoTo100 = new BigIntegerRepresentation(BigInteger.valueOf(2L).pow(100));
    protected static final StringRepresentation someString = new StringRepresentation("this is a test string");
    protected static final StringRepresentation emptyString = new StringRepresentation("");
    protected static final RepresentableRepresentation reprOfZn = new RepresentableRepresentation((Representable)new Zn(BigInteger.TEN));
    protected static final ByteArrayRepresentation bytes = new ByteArrayRepresentation(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, -13});
    private static boolean debugLog = true;

    public ConverterTest(Converter converter) {
        this.converter = converter;
    }

    protected void assertSerializationWorks(Representation repr) {
        Object serialization = this.converter.serialize(repr);
        this.debugLog("Serialized:", serialization);
        Representation deserialization = this.converter.deserialize(serialization);
        this.debugLog("Deserialized:", deserialization);
        this.debugLog("Original:", repr);
        Assert.assertEquals((Object)repr, (Object)deserialization);
    }

    protected void debugLog(String explanation, Object value) {
        if (!debugLog) {
            return;
        }
        if (value == null) {
            System.out.println(explanation + " null");
        } else if (value instanceof byte[]) {
            System.out.println(explanation + " " + Arrays.toString((byte[])value));
        } else {
            System.out.println(explanation + " " + value.toString());
        }
    }

    protected void debugLog(String str) {
        if (!debugLog) {
            return;
        }
        System.out.println(str);
    }

    @Test
    public void checkBigInt() {
        this.assertSerializationWorks((Representation)five);
        this.assertSerializationWorks((Representation)twoTo100);
    }

    @Test
    public void checkString() {
        this.assertSerializationWorks((Representation)someString);
        this.assertSerializationWorks((Representation)emptyString);
    }

    @Test
    public void checkRepresentableRepresentation() {
        this.assertSerializationWorks((Representation)reprOfZn);
    }

    @Test
    public void checkNull() {
        this.assertSerializationWorks(null);
    }

    @Test
    public void checkByteArray() {
        this.assertSerializationWorks((Representation)bytes);
    }

    @Test
    public void checkList() {
        ListRepresentation list = new ListRepresentation(new Representation[]{bytes, emptyString, someString, null, five, twoTo100});
        this.assertSerializationWorks((Representation)list);
    }

    @Test
    public void checkObject() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("bytes", (Representation)bytes);
        repr.put("emptyStr", (Representation)emptyString);
        repr.put("null", null);
        repr.put("someString", (Representation)someString);
        repr.put("twoTo100", (Representation)twoTo100);
        this.assertSerializationWorks((Representation)repr);
    }

    @Test
    public void checkMap() {
        MapRepresentation repr = new MapRepresentation();
        repr.put((Representation)bytes, (Representation)emptyString);
        repr.put((Representation)someString, (Representation)twoTo100);
        this.assertSerializationWorks((Representation)repr);
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Converter> getParams() {
        ArrayList<Converter> list = new ArrayList<Converter>();
        list.add((Converter)new JSONConverter());
        list.add((Converter)new JSONPrettyConverter());
        list.add((Converter)new BinaryFormatConverter());
        list.add((Converter)new BinaryFormatConverter(Arrays.asList(someString.get()), Arrays.asList(Zn.class)));
        return list;
    }
}

