/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplNoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplTotal;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupTests {
    protected Group group;
    protected Supplier<GroupElement> elementSupplier;

    public GroupTests(TestParams params) {
        this.group = params.group;
        this.elementSupplier = params.elementSupplier;
    }

    @Test
    public void testMultiexp() {
        try {
            this.group.size();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int n = 20;
        GroupElement g = this.elementSupplier.get();
        List h = Stream.generate(this.elementSupplier).limit(n).collect(Collectors.toList());
        List exponents = Stream.generate(() -> ((Group)this.group).getUniformlyRandomExponent()).limit(n).collect(Collectors.toList());
        GroupElement resultMultiexp = g;
        for (int i2 = 0; i2 < n; ++i2) {
            resultMultiexp = resultMultiexp.op((Element)((GroupElement)h.get(i2)).pow((Zn.ZnElement)exponents.get(i2)));
        }
        GroupElement resultMultexpWay2 = g;
        for (int i3 = 0; i3 < n; ++i3) {
            resultMultexpWay2 = resultMultexpWay2.op((Element)((GroupElement)h.get(i3)).pow((Zn.ZnElement)exponents.get(i3))).computeSync();
        }
        resultMultiexp.compute();
        Assert.assertEquals((Object)resultMultiexp, (Object)resultMultexpWay2);
        Zn.ZnElement z = this.group.getUniformlyRandomUnitExponent();
        GroupElement everythingRaisedToZ = g.pow(z);
        for (int i4 = 0; i4 < n; ++i4) {
            everythingRaisedToZ = everythingRaisedToZ.op((Element)((GroupElement)h.get(i4)).pow(((Zn.ZnElement)exponents.get(i4)).mul((Element)z)));
        }
        Assert.assertEquals((Object)resultMultiexp.pow(z), (Object)everythingRaisedToZ);
        List otherExponents = Stream.generate(() -> ((Group)this.group).getUniformlyRandomExponent()).limit(n).collect(Collectors.toList());
        Zn.ZnElement innerProduct = IntStream.range(0, n).mapToObj(i -> ((Zn.ZnElement)otherExponents.get(i)).mul((Element)exponents.get(i))).reduce(Zn.ZnElement::add).get();
        Assert.assertEquals((Object)g.pow(innerProduct), (Object)IntStream.range(0, n).mapToObj(i -> g.pow((Zn.ZnElement)otherExponents.get(i)).pow((Zn.ZnElement)exponents.get(i))).reduce(GroupElement::op).get());
        Assert.assertEquals((Object)g.pow((Zn.ZnElement)exponents.get(0)).pow((Zn.ZnElement)exponents.get(1)), (Object)g.pow((Zn.ZnElement)exponents.get(1)).pow((Zn.ZnElement)exponents.get(0)));
    }

    @Test
    public void testBasicProperties() {
        GroupElement a = null;
        GroupElement b = null;
        try {
            a = this.group.getUniformlyRandomElement();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        try {
            a = this.group.getUniformlyRandomNonNeutral();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        a = this.elementSupplier.get();
        b = this.elementSupplier.get();
        GroupElement c = this.elementSupplier.get();
        Assert.assertEquals((Object)a.inv().op((Element)a), (Object)this.group.getNeutralElement());
        Assert.assertEquals((Object)a.op((Element)a.inv()), (Object)this.group.getNeutralElement());
        Assert.assertEquals((Object)a.op((Element)b).op((Element)c), (Object)a.op((Element)b.op((Element)c)));
        if (this.group.isCommutative()) {
            Assert.assertEquals((String)"Commutativity", (Object)a.op((Element)b), (Object)b.op((Element)a));
        }
        BigInteger exponent = BigInteger.TEN;
        if (this.group.isCommutative()) {
            Assert.assertEquals((String)"Exponentiation+Commutativity", (Object)a.op((Element)b).pow(exponent), (Object)a.pow(exponent).op((Element)b.pow(exponent)));
        }
        Assert.assertEquals((Object)a.op((Element)this.group.getNeutralElement()), (Object)a);
        Assert.assertEquals((Object)this.group.getNeutralElement().op((Element)a), (Object)a);
        GroupElement aToTheFifth = a.op((Element)a).op((Element)a).op((Element)a).op((Element)a);
        Assert.assertEquals((String)"Exponentiation", (Object)a.pow(5L), (Object)aToTheFifth);
        Assert.assertEquals((String)"Exponentiation with negative exponent", (Object)a.pow(-5L), (Object)aToTheFifth.inv());
        BigInteger size = null;
        try {
            size = this.group.size();
            Assert.assertTrue((size == null || size.signum() >= 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (size != null) {
            Assert.assertTrue((String)"Lagrange", (boolean)a.pow(size).isNeutralElement());
            Assert.assertEquals((String)"Lagrange inversion", (Object)a.pow(size.subtract(BigInteger.ONE)), (Object)a.inv());
            BigInteger r = new Zn(this.group.size()).getUniformlyRandomElement().asInteger();
            if (size.isProbablePrime(100)) {
                Assert.assertEquals((Object)a.op((Element)b).pow(r).op((Element)b.pow(r.negate())), (Object)a.pow(r));
            } else {
                Assert.assertEquals((Object)a.pow(r).op((Element)b.pow(r)).op((Element)b.pow(r.negate())), (Object)a.pow(r));
            }
            Assert.assertEquals((Object)a.pow(r.multiply(BigInteger.valueOf(42L))), (Object)a.pow(r).pow(42L));
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        GroupElement b;
        GroupElement a = this.elementSupplier.get();
        if (a == (b = a.op((Element)a).op((Element)a.inv()))) {
            System.out.println("Warning: could not test hash code ementation for " + this.group);
        }
        Assert.assertTrue((a.equals(b) && b.equals(a) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Equal elements should have the same hashCode", (long)a.hashCode(), (long)b.hashCode());
    }

    @Test
    public void testUniqueRepresentations() {
        Optional ubrLength = Optional.empty();
        try {
            ubrLength = this.group.getUniqueByteLength();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (ubrLength.isPresent()) {
            GroupElement a = this.elementSupplier.get();
            GroupElement b = this.elementSupplier.get();
            try {
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)a.getUniqueByteRepresentation().length);
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)b.getUniqueByteRepresentation().length);
                Assert.assertTrue((String)"Uniqueness", (a.equals(b) || !Arrays.equals(a.getUniqueByteRepresentation(), b.getUniqueByteRepresentation()) ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
            }
        }
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        DebugGroupImplNoExpMultiExp debugGroupImplNoExpMultiExp = new DebugGroupImplNoExpMultiExp("testGroupImpl", BigInteger.probablePrime(128, new Random()));
        DebugGroupImplTotal debugGroupImplTotal = new DebugGroupImplTotal("testGroupImpl", BigInteger.probablePrime(128, new Random()));
        BasicGroup basicGroupNEME = new BasicGroup((GroupImpl)debugGroupImplNoExpMultiExp);
        LazyGroup lazyGroupNEME = new LazyGroup((GroupImpl)debugGroupImplNoExpMultiExp);
        BasicGroup basicGroupTotal = new BasicGroup((GroupImpl)debugGroupImplTotal);
        LazyGroup lazyGroupTotal = new LazyGroup((GroupImpl)debugGroupImplTotal);
        TestParams[][] params = new TestParams[][]{{new TestParams((Group)basicGroupNEME)}, {new TestParams((Group)basicGroupTotal)}, {new TestParams((Group)lazyGroupNEME)}, {new TestParams((Group)lazyGroupTotal)}};
        return Arrays.asList(params);
    }

    @Test
    public void testStructureRepresentation() {
        RepresentableRepresentation repr = new RepresentableRepresentation((Representable)this.group);
        Group s2 = (Group)repr.recreateRepresentable();
        Assert.assertEquals((String)"Reserialized Group should be equal to original", (Object)this.group, (Object)s2);
        Assert.assertEquals((String)"Reserialized Group's hashCode should be equal to original", (long)this.group.hashCode(), (long)s2.hashCode());
    }

    @Test
    public void testElementRepresentation() {
        GroupElement elem = this.elementSupplier.get();
        Representation repr = elem.getRepresentation();
        GroupElement elem2 = this.group.restoreElement(repr);
        Assert.assertEquals((String)"Reserialized element should be equal to original", (Object)elem, (Object)elem2);
        Assert.assertEquals((String)"Reserialized element's hashCode should be equal to original", (long)elem.hashCode(), (long)elem2.hashCode());
    }

    protected static class TestParams {
        Group group;
        Supplier<GroupElement> elementSupplier;

        public TestParams(Group group, Supplier<GroupElement> elementSupplier) {
            this.group = group;
            this.elementSupplier = elementSupplier;
        }

        public TestParams(Group group) {
            this(group, () -> ((Group)group).getUniformlyRandomElement());
        }

        public String toString() {
            return this.group.getClass().getName() + " - " + this.group.toString();
        }
    }
}

