/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BasicNamedBoolVariableExpr;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.exponent.BasicNamedExponentVariableExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.BasicNamedGroupVariableExpr;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;

public interface Expression {
    default public Expression substitute(String variable, Expression substitution) {
        if (substitution instanceof GroupElementExpression) {
            return this.substitute(new BasicNamedGroupVariableExpr(variable), substitution);
        }
        if (substitution instanceof ExponentExpr) {
            return this.substitute(new BasicNamedExponentVariableExpr(variable), substitution);
        }
        if (substitution instanceof BooleanExpression) {
            return this.substitute(new BasicNamedBoolVariableExpr(variable), substitution);
        }
        throw new IllegalArgumentException("Don't know how to handle " + substitution.getClass());
    }

    default public Expression substitute(VariableExpression variable, Expression substitution) {
        return this.substitute(expr -> variable.equals(expr) ? substitution : null);
    }

    public Expression substitute(Substitution var1);

    public Object evaluate();

    public Object evaluate(Substitution var1);

    default public Set<VariableExpression> getVariables() {
        HashSet<VariableExpression> result = new HashSet<VariableExpression>();
        this.treeWalk(node -> {
            if (node instanceof VariableExpression) {
                result.add((VariableExpression)node);
            }
        });
        return result;
    }

    default public boolean containsVariables() {
        return !this.getVariables().isEmpty();
    }

    default public void treeWalk(Consumer<Expression> visitor) {
        visitor.accept(this);
        this.forEachChild(expr -> expr.treeWalk(visitor));
    }

    public void forEachChild(Consumer<Expression> var1);

    default public <T> T accumulate(BiFunction<T, Expression, T> accumulator, T initialValue) {
        ArrayList value = new ArrayList(1);
        value.add(initialValue);
        this.treeWalk(expr -> value.set(0, accumulator.apply((Object)value.get(0), (Expression)expr)));
        return (T)value.get(0);
    }

    default public boolean containsExprMatchingPredicate(Predicate<Expression> predicate) {
        return this.accumulate((hasPredicateExpr, expr) -> predicate.test((Expression)expr) || hasPredicateExpr != false, false);
    }
}

