/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentNegExpr
implements ExponentExpr {
    protected final ExponentExpr child;

    public ExponentNegExpr(ExponentExpr child) {
        this.child = child;
    }

    public ExponentExpr getChild() {
        return this.child;
    }

    @Override
    public BigInteger evaluate() {
        return this.child.evaluate().negate();
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.child);
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return this.child.evaluate(zn).neg();
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this.child.substitute(substitutions).negate();
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        ExponentSumExpr childLinearized = this.child.linearize();
        return new ExponentSumExpr(childLinearized.getLhs().negate(), childLinearized.getRhs().negate());
    }
}

