/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.math.BigInteger;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.GroupEqualityExpr;
import org.cryptimeleon.math.expressions.exponent.BasicNamedExponentVariableExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentConstantExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.BasicNamedGroupVariableExpr;
import org.cryptimeleon.math.expressions.group.GroupElementConstantExpr;
import org.cryptimeleon.math.expressions.group.GroupInvExpr;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.expressions.group.GroupPowExpr;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface GroupElementExpression
extends Expression {
    @Override
    default public GroupElement evaluate() {
        return this.evaluate(x -> null);
    }

    @Override
    public GroupElement evaluate(Substitution var1);

    @Override
    public GroupElementExpression substitute(Substitution var1);

    @Override
    default public GroupElementExpression substitute(String variable, Expression substitution) {
        return (GroupElementExpression)Expression.super.substitute(variable, substitution);
    }

    @Override
    default public GroupElementExpression substitute(VariableExpression variable, Expression substitution) {
        return (GroupElementExpression)Expression.super.substitute(variable, substitution);
    }

    default public GroupElementExpression op(GroupElementExpression rhs) {
        return new GroupOpExpr(this, rhs);
    }

    default public GroupElementExpression op(GroupElement rhs) {
        return new GroupOpExpr(this, new GroupElementConstantExpr(rhs));
    }

    default public GroupElementExpression op(String rhs) {
        return new GroupOpExpr(this, new BasicNamedGroupVariableExpr(rhs));
    }

    default public GroupElementExpression pow(ExponentExpr exponent) {
        return new GroupPowExpr(this, exponent);
    }

    default public GroupElementExpression pow(BigInteger exponent) {
        return this.pow(new ExponentConstantExpr(exponent));
    }

    default public GroupElementExpression pow(Long exponent) {
        return this.pow(new ExponentConstantExpr(exponent));
    }

    default public GroupElementExpression pow(RingElement exponent) {
        return this.pow(new ExponentConstantExpr(exponent.asInteger()));
    }

    default public GroupElementExpression pow(String exponent) {
        return this.pow(new BasicNamedExponentVariableExpr(exponent));
    }

    default public GroupElementExpression opPow(GroupElementExpression rhs, ExponentExpr exponentOfRhs) {
        return this.op(rhs.pow(exponentOfRhs));
    }

    default public GroupElementExpression opPow(GroupElementExpression rhs, BigInteger exponentOfRhs) {
        return this.op(rhs.pow(new ExponentConstantExpr(exponentOfRhs)));
    }

    default public GroupElementExpression opPow(GroupElementExpression rhs, Zn.ZnElement exponentOfRhs) {
        return this.op(rhs.pow(new ExponentConstantExpr(exponentOfRhs)));
    }

    default public GroupElementExpression opPow(GroupElementExpression rhs, String exponentOfRhs) {
        return this.op(rhs.pow(new BasicNamedExponentVariableExpr(exponentOfRhs)));
    }

    default public GroupElementExpression opPow(GroupElement rhs, ExponentExpr exponentOfRhs) {
        return this.op(rhs.expr().pow(exponentOfRhs));
    }

    default public GroupElementExpression opPow(GroupElement rhs, BigInteger exponentOfRhs) {
        return this.op(rhs.expr().pow(new ExponentConstantExpr(exponentOfRhs)));
    }

    default public GroupElementExpression opPow(GroupElement rhs, Zn.ZnElement exponentOfRhs) {
        return this.op(rhs.expr().pow(new ExponentConstantExpr(exponentOfRhs)));
    }

    default public GroupElementExpression opPow(GroupElement rhs, String exponentOfRhs) {
        return this.op(rhs.expr().pow(new BasicNamedExponentVariableExpr(exponentOfRhs)));
    }

    default public GroupElementExpression inv() {
        return new GroupInvExpr(this);
    }

    default public GroupEqualityExpr isEqualTo(GroupElementExpression other) {
        return new GroupEqualityExpr(this, other);
    }

    default public GroupEqualityExpr isEqualTo(GroupElement other) {
        return new GroupEqualityExpr(this, other.expr());
    }

    default public GroupEqualityExpr isEqualTo(String other) {
        return this.isEqualTo(new BasicNamedGroupVariableExpr(other));
    }

    public Group getGroup();

    default public GroupElementExpression precompute() {
        GroupOpExpr flattened = this.flatten();
        flattened.getLhs().evaluate().computeSync();
        flattened.treeWalk(expr -> {
            GroupElementExpression base;
            if (expr instanceof GroupPowExpr && (base = ((GroupPowExpr)expr).getBase()) instanceof GroupElementConstantExpr) {
                ((GroupElementConstantExpr)base).value.precomputePow();
            }
        });
        return flattened;
    }

    public GroupOpExpr linearize() throws IllegalArgumentException;

    default public GroupOpExpr flatten() {
        return this.flatten(new ExponentConstantExpr(BigInteger.ONE));
    }

    public GroupOpExpr flatten(ExponentExpr var1);
}

