/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.Vector;

public interface Structure
extends StandaloneRepresentable {
    public BigInteger size() throws UnsupportedOperationException;

    default public boolean hasPrimeSize() {
        try {
            BigInteger size = this.size();
            if (size == null) {
                return false;
            }
            return size.isProbablePrime(80);
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    public Element getUniformlyRandomElement() throws UnsupportedOperationException;

    public Vector<? extends Element> getUniformlyRandomElements(int var1) throws UnsupportedOperationException;

    public Element restoreElement(Representation var1);

    public Optional<Integer> getUniqueByteLength();
}

