/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.bool;

import java.math.BigInteger;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.ByteArrayRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.bool.BooleanStructure;

public class BooleanElement
implements RingElement {
    protected boolean value;
    public static BooleanElement TRUE = new BooleanElement(true);
    public static BooleanElement FALSE = new BooleanElement(false);

    public BooleanElement(boolean value) {
        this.value = value;
    }

    public BooleanElement(Representation repr) {
        this(repr.bytes().get()[0] != 0);
    }

    @Override
    public Ring getStructure() {
        return new BooleanStructure();
    }

    @Override
    public RingElement add(Element e) {
        return ((BooleanElement)e).value != this.value ? TRUE : FALSE;
    }

    @Override
    public RingElement neg() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public RingElement mul(Element e) {
        return ((BooleanElement)e).value && this.value ? TRUE : FALSE;
    }

    @Override
    public RingElement inv() throws UnsupportedOperationException {
        if (!this.value) {
            throw new UnsupportedOperationException("Cannot invert FALSE");
        }
        return TRUE;
    }

    public BooleanElement or(Element e) {
        return ((BooleanElement)e).value || this.value ? TRUE : FALSE;
    }

    @Override
    public boolean divides(RingElement e) throws UnsupportedOperationException {
        return this.value || !((BooleanElement)e).value;
    }

    @Override
    public RingElement[] divideWithRemainder(RingElement e) throws UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BigInteger getRank() throws UnsupportedOperationException {
        return BigInteger.ONE;
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.append(this.value ? 1 : 0);
        return accumulator;
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BooleanElement && ((BooleanElement)obj).value == this.value;
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    public Representation getRepresentation() {
        return new ByteArrayRepresentation(new byte[]{(byte)(this.value ? 1 : 0)});
    }

    @Override
    public BigInteger asInteger() throws UnsupportedOperationException {
        return this.value ? BigInteger.ONE : BigInteger.ZERO;
    }
}

