/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Test;

public class ReprUtilTest {
    @Represented(restorer="(Str -> R) -> [Str]")
    HashMap<Map<String, RingElement>, List<String>> nestedMap;
    @Represented(restorer="foo::getFoo::getZp")
    Zp.ZpElement zpelem;
    @Represented
    Foo foo;
    @Represented
    byte[] smallNumbers;
    @Represented
    Integer boringOldInteger;
    @Represented
    Long longNUmber;
    @Represented
    BigInteger reeeaaallyLongNumber;
    @Represented
    UUID veryUniqueNumber;

    private void populate() {
        Zn ring = new Zn(BigInteger.TEN);
        this.nestedMap = new HashMap();
        HashMap<String, RingElement> inner = new HashMap<String, RingElement>();
        inner.put("testInner", ring.getUniformlyRandomElement());
        this.nestedMap.put(inner, Arrays.asList("testOuter", "testOuter2"));
        this.foo = new Foo(new Zp(BigInteger.valueOf(3L)));
        this.zpelem = Zp.valueOf((long)2L, (long)3L);
        this.smallNumbers = RandomGenerator.getRandomBytes((int)3);
        this.boringOldInteger = 23;
        this.longNUmber = Long.MAX_VALUE;
        this.reeeaaallyLongNumber = BigInteger.TEN.pow(100);
        this.veryUniqueNumber = UUID.randomUUID();
    }

    @Test
    public void testRestoration() {
        Zn ring = new Zn(BigInteger.TEN);
        Representation repr = ReprUtil.serialize((Object)this);
        ReprUtilTest deserialized = new ReprUtilTest();
        new ReprUtil((Object)deserialized).register((RepresentationRestorer)ring, "R").deserialize(repr);
        Assert.assertEquals((Object)deserialized, (Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReprUtilTest that = (ReprUtilTest)o;
        return Objects.equals(this.nestedMap, that.nestedMap) && Objects.equals(this.zpelem, that.zpelem) && Objects.equals(this.foo, that.foo) && Arrays.equals(this.smallNumbers, that.smallNumbers) && Objects.equals(this.boringOldInteger, that.boringOldInteger) && Objects.equals(this.longNUmber, that.longNUmber) && Objects.equals(this.reeeaaallyLongNumber, that.reeeaaallyLongNumber) && Objects.equals(this.veryUniqueNumber, that.veryUniqueNumber);
    }

    public int hashCode() {
        int result = Objects.hash(this.nestedMap, this.zpelem, this.foo, this.boringOldInteger, this.longNUmber, this.reeeaaallyLongNumber, this.veryUniqueNumber);
        result = 31 * result + Arrays.hashCode(this.smallNumbers);
        return result;
    }

    public static class Foo
    implements StandaloneRepresentable {
        @Represented
        Zp zp;

        public Foo() {
            this(new Zp(BigInteger.valueOf(17L)));
        }

        public Foo(Zp zp) {
            this.zp = zp;
        }

        public Foo(Representation repr) {
            ReprUtil.deserialize((Object)this, (Representation)repr);
        }

        public Zp getZp() {
            return new Zp(BigInteger.valueOf(3L));
        }

        public Foo getFoo() {
            return this;
        }

        public Representation getRepresentation() {
            return ReprUtil.serialize((Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Foo foo = (Foo)o;
            return Objects.equals(this.zp, foo.zp);
        }

        public int hashCode() {
            return Objects.hash(this.zp);
        }
    }
}

