/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.AbstractGroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class GroupInvExpr
extends AbstractGroupElementExpression {
    protected GroupElementExpression base;

    public GroupInvExpr(@Nonnull GroupElementExpression base) {
        super(base.getGroup());
        this.base = base;
    }

    public GroupElementExpression getBase() {
        return this.base;
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.base);
    }

    @Override
    public GroupElement evaluate(Substitution substitutions) {
        return this.base.evaluate(substitutions).inv();
    }

    @Override
    public GroupElementExpression substitute(Substitution substitutions) {
        return this.base.substitute(substitutions).inv();
    }

    @Override
    public GroupElementExpression inv() {
        return this.base;
    }

    @Override
    public GroupOpExpr linearize() throws IllegalArgumentException {
        GroupOpExpr baseLinear = this.base.linearize();
        return new GroupOpExpr(baseLinear.getLhs().inv(), baseLinear.getRhs().inv());
    }

    @Override
    public GroupOpExpr flatten(ExponentExpr exponent) {
        return this.base.flatten(exponent.negate());
    }
}

