/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.EvaluationException;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public interface GroupVariableExpr
extends GroupElementExpression,
VariableExpression {
    @Override
    default public GroupElement evaluate() {
        throw new EvaluationException(this, "Variable cannot be evaluated");
    }

    @Override
    default public GroupElement evaluate(Substitution substitutions) {
        GroupElementExpression substitution = (GroupElementExpression)substitutions.getSubstitution(this);
        if (substitution == null) {
            throw new EvaluationException(this, "Variable cannot be evaluated");
        }
        return substitution.evaluate();
    }

    @Override
    default public GroupElementExpression substitute(Substitution substitutions) {
        Expression replacement = substitutions.getSubstitution(this);
        if (replacement != null) {
            return (GroupElementExpression)replacement;
        }
        return this;
    }

    @Override
    default public Group getGroup() {
        return null;
    }

    @Override
    default public GroupOpExpr flatten(ExponentExpr exponent) {
        return new GroupOpExpr(new GroupEmptyExpr(this.getGroup()), this.pow(exponent));
    }

    @Override
    default public void forEachChild(Consumer<Expression> action) {
    }

    @Override
    default public GroupOpExpr linearize() throws IllegalArgumentException {
        return new GroupOpExpr(new GroupEmptyExpr(), this);
    }
}

