/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.converter.JSONConverter;
import org.cryptimeleon.math.structures.cartesian.Vector;

public class ListRepresentation
extends Representation
implements Iterable<Representation> {
    private static final long serialVersionUID = -7782043563152429201L;
    protected final List<Representation> list = new ArrayList<Representation>();

    public ListRepresentation() {
    }

    public ListRepresentation(Vector<? extends Representation> vector) {
        this(vector.toList());
    }

    public ListRepresentation(List<? extends Representation> list) {
        this.list.addAll(list);
    }

    public ListRepresentation(Representation ... list) {
        this.list.addAll(Arrays.asList(list));
    }

    public Representation get(int i) {
        return this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    public void put(Representation value) {
        this.list.add(value);
    }

    public void add(Representation value) {
        this.put(value);
    }

    public List<Representation> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public Representation[] getArray() {
        return this.list.toArray(new Representation[this.list.size()]);
    }

    @Override
    public Iterator<Representation> iterator() {
        return this.list.iterator();
    }

    public Stream<Representation> stream() {
        return this.list.stream();
    }

    public String toString() {
        return new JSONConverter().serialize(this);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRepresentation other = (ListRepresentation)obj;
        return this.list.equals(other.list);
    }
}

