/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingTargetGroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingTargetGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

public abstract class AbstractPairing
implements BilinearMapImpl {
    protected PairingSourceGroupImpl g1;
    protected PairingSourceGroupImpl g2;
    protected PairingTargetGroupImpl gT;

    protected void init(PairingSourceGroupImpl g1, PairingSourceGroupImpl g2, PairingTargetGroupImpl gT) {
        this.g1 = g1;
        this.g2 = g2;
        this.gT = gT;
    }

    public AbstractPairing(PairingSourceGroupImpl g1, PairingSourceGroupImpl g2, PairingTargetGroupImpl gT) {
        this.init(g1, g2, gT);
    }

    @Override
    public PairingTargetGroupElementImpl apply(GroupElementImpl g, GroupElementImpl h, BigInteger exponent) {
        return this.exponentiate(this.pair((PairingSourceGroupElement)g.pow(exponent), (PairingSourceGroupElement)h));
    }

    public PairingTargetGroupElementImpl exponentiate(FieldElement f) {
        return this.gT.getElement((ExtensionFieldElement)f.pow(this.gT.getCofactor()));
    }

    protected abstract ExtensionFieldElement evaluateLine(FieldElement[] var1, PairingSourceGroupElement var2, PairingSourceGroupElement var3);

    protected abstract ExtensionFieldElement pair(PairingSourceGroupElement var1, PairingSourceGroupElement var2);

    protected ExtensionFieldElement miller(PairingSourceGroupElement P, PairingSourceGroupElement Q, BigInteger n) {
        ExtensionField targetField = this.gT.getFieldOfDefinition();
        FieldElement millerVariable = targetField.getOneElement();
        PairingSourceGroupElement pNormalized = (PairingSourceGroupElement)P.normalize();
        PairingSourceGroupElement qNormalized = (PairingSourceGroupElement)Q.normalize();
        PairingSourceGroupElement R = pNormalized;
        for (int i = n.bitLength() - 2; i >= 0; --i) {
            millerVariable = millerVariable.square();
            FieldElement[] line = R.computeLine(R);
            millerVariable = millerVariable.mul(this.evaluateLine(line, R, qNormalized));
            R = (PairingSourceGroupElement)R.add(R, line);
            if (!n.testBit(i)) continue;
            line = R.computeLine(pNormalized);
            millerVariable = millerVariable.mul(this.evaluateLine(line, R, qNormalized));
            R = (PairingSourceGroupElement)R.add(pNormalized, line);
        }
        return millerVariable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractPairing that = (AbstractPairing)other;
        return Objects.equals(this.g1, that.g1) && Objects.equals(this.g2, that.g2) && Objects.equals(this.gT, that.gT);
    }

    public int hashCode() {
        return Objects.hash(this.g1, this.g2, this.gT);
    }
}

