/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.mcl;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.mcl.MclGroup1ElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.mcl.MclGroupImpl;

public abstract class MclGroupElementImpl
implements GroupElementImpl {
    protected MclGroupImpl group;
    protected Object element;

    public MclGroupElementImpl(MclGroupImpl group, Object element) {
        this.group = group;
        this.element = element;
    }

    public MclGroupElementImpl(MclGroupImpl group, Representation repr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Representation part : repr.list()) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(part.bigInt().get().toString());
            first = false;
        }
        this.group = group;
        this.element = group.getInternalObjectFromString(sb.toString());
    }

    protected Object getElement() {
        return this.element;
    }

    public GroupImpl getStructure() {
        return this.group;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.escapeAndAppend(this.getElement().toString());
        return accumulator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MclGroup1ElementImpl that = (MclGroup1ElementImpl)other;
        return this.getElement().equals(that.getElement()) && Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.element.toString());
    }

    public Representation getRepresentation() {
        ListRepresentation result = new ListRepresentation();
        String repr = this.getElement().toString();
        for (String str : repr.split(" ")) {
            result.put((Representation)new BigIntegerRepresentation(new BigInteger(str)));
        }
        return result;
    }

    public String toString() {
        return this.getElement().toString();
    }
}

