/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.mcl;

import com.herumi.mcl.Fr;
import com.herumi.mcl.GT;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.mcl.MclGroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.mcl.MclGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.mcl.MclGroupTImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class MclGroupTElementImpl
extends MclGroupElementImpl {
    public MclGroupTElementImpl(MclGroupTImpl group, Representation repr) {
        super((MclGroupImpl)group, repr);
    }

    public MclGroupTElementImpl(MclGroupTImpl group, GT elem) {
        super((MclGroupImpl)group, elem);
    }

    @Override
    protected GT getElement() {
        return (GT)super.getElement();
    }

    @Override
    public MclGroupTImpl getStructure() {
        return (MclGroupTImpl)super.getStructure();
    }

    public MclGroupTElementImpl inv() {
        GT res = new GT();
        Mcl.inv(res, this.getElement());
        return this.getStructure().createElement(res);
    }

    public MclGroupTElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
        GT res = new GT();
        Mcl.mul(res, this.getElement(), ((MclGroupTElementImpl)e).getElement());
        return this.getStructure().createElement(res);
    }

    public MclGroupTElementImpl pow(BigInteger k) {
        return this.pow(Zn.valueOf((BigInteger)k, (BigInteger)this.getStructure().size()));
    }

    public MclGroupTElementImpl pow(Zn.ZnElement k) {
        GT res = new GT();
        Fr exponent = new Fr(k.getInteger().toString());
        Mcl.pow(res, this.getElement(), exponent);
        return this.getStructure().createElement(res);
    }

    public boolean isNeutralElement() {
        return this.getElement().isOne();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MclGroupTElementImpl that = (MclGroupTElementImpl)other;
        return this.getElement().equals(that.getElement()) && Objects.equals(this.group, that.group);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

