/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.G1;
import com.herumi.mcl.G2;
import com.herumi.mcl.GT;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroup1Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroup2Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroupElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroupImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroupTElementImpl;

class MclGroupTImpl
extends MclGroupImpl {
    protected MclGroupTElementImpl generator = null;

    public MclGroupTImpl() {
    }

    public MclGroupTImpl(Representation repr) {
        super(repr);
    }

    @Override
    public MclGroupElementImpl getElement(String string) {
        return this.createElement(this.getInternalObjectFromString(string));
    }

    public GroupElementImpl restoreElement(Representation repr) {
        return new MclGroupTElementImpl(this, repr);
    }

    @Override
    protected GT getInternalObjectFromString(String str) {
        GT result = new GT();
        result.setStr(str);
        return result;
    }

    protected MclGroupTElementImpl createElement(GT GT2) {
        return new MclGroupTElementImpl(this, GT2);
    }

    public GroupElementImpl getNeutralElement() {
        return this.getElement("1 0 0 0 0 0 0 0 0 0 0 0");
    }

    public GroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.getGenerator().pow(RandomGenerator.getRandomNumber((BigInteger)this.size()));
    }

    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        if (this.generator != null) {
            return this.generator;
        }
        G1 g = new MclGroup1Impl().getGenerator().getElement();
        G2 h = new MclGroup2Impl().getGenerator().getElement();
        GT res = new GT();
        Mcl.pairing(res, g, h);
        this.generator = this.createElement(res);
        return this.generator;
    }

    public double estimateCostInvPerOp() {
        return 3.4;
    }
}

