/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.G1;
import com.herumi.mcl.Mcl;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroup1Impl;

class MclHashIntoG1Impl
implements HashIntoGroupImpl {
    protected MclGroup1Impl group;

    public MclHashIntoG1Impl(MclGroup1Impl group) {
        this.group = group;
    }

    public MclHashIntoG1Impl(Representation repr) {
        this.group = new MclGroup1Impl(repr);
    }

    public GroupElementImpl hashIntoGroupImpl(byte[] x) {
        G1 result = new G1();
        Mcl.hashAndMapToG1(result, x);
        return this.group.createElement(result);
    }

    public Representation getRepresentation() {
        return this.group.getRepresentation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MclHashIntoG1Impl that = (MclHashIntoG1Impl)o;
        return this.group.equals(that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }
}

