/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.Mcl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.mclwrap.bn254.MclBilinearGroup;
import org.cryptimeleon.mclwrap.bn254.MclGroup1Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroup2Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroupTImpl;
import org.cryptimeleon.mclwrap.bn254.MclHashIntoG1Impl;
import org.cryptimeleon.mclwrap.bn254.MclHashIntoG2Impl;
import org.cryptimeleon.mclwrap.bn254.MclPairing;

class MclBilinearGroupImpl
implements BilinearGroupImpl {
    protected static MclBilinearGroup.GroupChoice initializedGroup = null;
    protected MclGroup1Impl g1;
    protected MclGroup2Impl g2;
    protected MclGroupTImpl gt;
    protected MclHashIntoG1Impl hashIntoG1;
    protected MclHashIntoG2Impl hashIntoG2;

    public MclBilinearGroupImpl(MclBilinearGroup.GroupChoice choice) {
        MclBilinearGroupImpl.init(choice);
        this.g1 = new MclGroup1Impl(choice);
        this.g2 = new MclGroup2Impl(choice);
        this.gt = new MclGroupTImpl(choice);
        this.hashIntoG1 = new MclHashIntoG1Impl(this.g1);
        this.hashIntoG2 = new MclHashIntoG2Impl(this.g2);
    }

    public MclBilinearGroupImpl(Representation repr) {
        this(MclBilinearGroup.GroupChoice.valueOf(repr.str().get()));
    }

    protected static boolean loadIncludedLibrary() {
        String tempdir;
        String platformName = System.getProperty("os.name").toLowerCase();
        String platformArch = System.getProperty("os.arch").toLowerCase();
        String requiredLibraryName = null;
        if (platformName.contains("win")) {
            if (platformArch.equals("x86")) {
                requiredLibraryName = "mcljava-win-x86.dll";
            }
            if (platformArch.equals("amd64") || platformArch.equals("x86_64")) {
                requiredLibraryName = "mcljava-win-x64.dll";
            }
        }
        if (platformName.contains("linux")) {
            if (platformArch.equals("x86") || platformArch.equals("i386")) {
                requiredLibraryName = "mcljava-linux-x86.so";
            }
            if (platformArch.equals("amd64") || platformArch.equals("x86_64")) {
                requiredLibraryName = "mcljava-linux-x64.so";
            }
        }
        if (platformName.contains("mac") && (platformArch.equals("amd64") || platformArch.equals("x86_64"))) {
            requiredLibraryName = "mcljava-mac-x64.dylib";
        }
        if (requiredLibraryName == null) {
            System.err.println("Could not find precompiled library for " + platformName + " " + platformArch);
            return false;
        }
        InputStream nativeLibrary = MclBilinearGroupImpl.class.getResourceAsStream(requiredLibraryName);
        if (nativeLibrary == null) {
            return false;
        }
        try {
            tempdir = Files.createTempDirectory("mclwrap", new FileAttribute[0]).toAbsolutePath().toString();
        }
        catch (IOException e) {
            return false;
        }
        File outputFile = new File(tempdir + File.separator + requiredLibraryName);
        try {
            Files.copy(nativeLibrary, outputFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        try {
            System.load(outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static synchronized void init(MclBilinearGroup.GroupChoice groupChoice) {
        if (initializedGroup == groupChoice) {
            return;
        }
        if (initializedGroup != null) {
            throw new IllegalArgumentException("mcl has already been initialized with " + (Object)((Object)initializedGroup) + ", you're trying to instantiate " + (Object)((Object)groupChoice) + ". We currently do not support running multiple mcl settings at once. It's a known limitation of mcl's Java wrapper. If you promise you won't use the old GroupElements anymore (or don't fear undefined behavior), you can call MclBilinearGroupImpl.resetMclInitialization() and then retry.");
        }
        String lib = "mcljava";
        try {
            System.loadLibrary(lib);
        }
        catch (UnsatisfiedLinkError le) {
            boolean couldLoadProvidedLibrary = MclBilinearGroupImpl.loadIncludedLibrary();
            if (!couldLoadProvidedLibrary) {
                le.printStackTrace();
                String libName = System.mapLibraryName(lib);
                System.err.println("If you get this error, the required native library " + libName + " was not found and none of the included libraries could be used!");
                System.err.println("You need to retrieve the native mcljava library that is appropriate for your platform and install it into one of the lib directories:");
                System.err.println(System.getProperty("java.library.path"));
                System.err.println("See README.md");
                return;
            }
            System.err.println("The required native mcl library was not found on this system, but one of the included pre-compiled libraries could be used.");
            System.err.println("mclwrap will work as expected, but for optimal run-time performance, please compile the mcljava library from source and install it into one of the lib directories:");
            System.err.println(System.getProperty("java.library.path"));
            System.err.println("See README.md");
        }
        try {
            Mcl.SystemInit(groupChoice.mclconstant);
        }
        catch (UnsatisfiedLinkError le) {
            throw new RuntimeException("mcl library was loaded, but cannot be initialized", le);
        }
        initializedGroup = groupChoice;
    }

    public MclGroup1Impl getG1() {
        return this.g1;
    }

    public MclGroup2Impl getG2() {
        return this.g2;
    }

    public MclGroupTImpl getGT() {
        return this.gt;
    }

    public BilinearMapImpl getBilinearMap() {
        return new MclPairing(this);
    }

    public GroupHomomorphismImpl getHomomorphismG2toG1() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No homomorphism (type 3)");
    }

    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return this.hashIntoG1;
    }

    public HashIntoGroupImpl getHashIntoG2() throws UnsupportedOperationException {
        return this.hashIntoG2;
    }

    public HashIntoGroupImpl getHashIntoGT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No hash available.");
    }

    public Integer getSecurityLevel() {
        switch (this.g1.groupChoice) {
            case BN254: {
                return 100;
            }
            case BLS12_381: {
                return 127;
            }
        }
        throw new IllegalArgumentException("unknown security level");
    }

    public BilinearGroup.Type getPairingType() {
        return BilinearGroup.Type.TYPE_3;
    }

    public Representation getRepresentation() {
        return new StringRepresentation(this.g1.groupChoice.name());
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof MclBilinearGroupImpl && ((MclBilinearGroupImpl)obj).g1.equals(this.g1);
    }

    public String toString() {
        return this.g1.groupChoice.toString();
    }
}

