/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.Fr;
import com.herumi.mcl.G1;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.mclwrap.bn254.MclGroup1Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroupElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroupImpl;

class MclGroup1ElementImpl
extends MclGroupElementImpl {
    public MclGroup1ElementImpl(MclGroup1Impl group, Representation repr) {
        super((MclGroupImpl)group, repr);
    }

    public MclGroup1ElementImpl(MclGroup1Impl group, G1 elem) {
        super((MclGroupImpl)group, elem);
    }

    @Override
    protected G1 getElement() {
        return (G1)super.getElement();
    }

    @Override
    public MclGroup1Impl getStructure() {
        return (MclGroup1Impl)super.getStructure();
    }

    public MclGroup1ElementImpl inv() {
        G1 res = new G1();
        Mcl.neg(res, this.getElement());
        return this.getStructure().createElement(res);
    }

    public MclGroup1ElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
        G1 res = new G1();
        if (e == this) {
            Mcl.dbl(res, this.getElement());
        } else {
            Mcl.add(res, this.getElement(), ((MclGroup1ElementImpl)e).getElement());
        }
        return this.getStructure().createElement(res);
    }

    public MclGroup1ElementImpl pow(BigInteger k) {
        return this.pow(Zn.valueOf((BigInteger)k, (BigInteger)this.getStructure().size()));
    }

    public MclGroup1ElementImpl pow(Zn.ZnElement k) {
        G1 res = new G1();
        Fr exponent = new Fr(k.asInteger().toString());
        Mcl.mul(res, this.getElement(), exponent);
        return this.getStructure().createElement(res);
    }

    public boolean isNeutralElement() {
        return this.getElement().isZero();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MclGroup1ElementImpl that = (MclGroup1ElementImpl)other;
        return this.getElement().equals(that.getElement()) && Objects.equals(this.group, that.group);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

