/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.Fr;
import com.herumi.mcl.G2;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.mclwrap.bn254.MclGroup2Impl;
import org.cryptimeleon.mclwrap.bn254.MclGroupElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroupImpl;

class MclGroup2ElementImpl
extends MclGroupElementImpl {
    public MclGroup2ElementImpl(MclGroup2Impl group, Representation repr) {
        super((MclGroupImpl)group, repr);
    }

    public MclGroup2ElementImpl(MclGroup2Impl group, G2 elem) {
        super((MclGroupImpl)group, elem);
    }

    @Override
    protected G2 getElement() {
        return (G2)super.getElement();
    }

    @Override
    public MclGroup2Impl getStructure() {
        return (MclGroup2Impl)super.getStructure();
    }

    public MclGroup2ElementImpl inv() {
        G2 res = new G2();
        Mcl.neg(res, this.getElement());
        return this.getStructure().createElement(res);
    }

    public MclGroup2ElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
        G2 res = new G2();
        if (e == this) {
            Mcl.dbl(res, this.getElement());
        } else {
            Mcl.add(res, this.getElement(), ((MclGroup2ElementImpl)e).getElement());
        }
        return this.getStructure().createElement(res);
    }

    public MclGroup2ElementImpl pow(BigInteger k) {
        return this.pow(Zn.valueOf((BigInteger)k, (BigInteger)this.getStructure().size()));
    }

    public MclGroup2ElementImpl pow(Zn.ZnElement k) {
        G2 res = new G2();
        Fr exponent = new Fr(k.asInteger().toString());
        Mcl.mul(res, this.getElement(), exponent);
        return this.getStructure().createElement(res);
    }

    public boolean isNeutralElement() {
        return this.getElement().isZero();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MclGroup2ElementImpl that = (MclGroup2ElementImpl)other;
        return this.getElement().equals(that.getElement()) && Objects.equals(this.group, that.group);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

