/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.Fr;
import com.herumi.mcl.G1;
import com.herumi.mcl.GT;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.mclwrap.bn254.MclBilinearGroupImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroup1ElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroup2ElementImpl;

class MclPairing
implements BilinearMapImpl {
    private MclBilinearGroupImpl bilinearGroup;

    public MclPairing(MclBilinearGroupImpl bilinearGroup) {
        this.bilinearGroup = bilinearGroup;
    }

    public MclPairing(Representation repr) {
        this(new MclBilinearGroupImpl(repr));
    }

    public GroupElementImpl apply(GroupElementImpl g1, GroupElementImpl g2, BigInteger exponent) {
        GT result = new GT();
        G1 g1Exponentiated = new G1();
        exponent = exponent.mod(this.bilinearGroup.getG1().size());
        Fr exp = new Fr();
        exp.setStr(exponent.toString(10));
        Mcl.mul(g1Exponentiated, ((MclGroup1ElementImpl)g1).getElement(), exp);
        Mcl.pairing(result, g1Exponentiated, ((MclGroup2ElementImpl)g2).getElement());
        return this.bilinearGroup.getGT().createElement(result);
    }

    public boolean isSymmetric() {
        return false;
    }

    public Representation getRepresentation() {
        return this.bilinearGroup.getRepresentation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MclPairing that = (MclPairing)o;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup);
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup);
    }
}

