/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.batchdlt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.ct42.fnflow.batchdlt.HeaderAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class MultiFnWrapper
implements BiFunction<Flux<Message<JsonNode>>, Sinks.Many<Message<Throwable>>, Flux<Message<JsonNode>>> {
    private final List<Function<JsonNode, JsonNode>> targets;

    public MultiFnWrapper(List<Function<JsonNode, JsonNode>> targets) {
        this.targets = targets;
    }

    @Override
    public Flux<Message<JsonNode>> apply(Flux<Message<JsonNode>> messageFlux, Sinks.Many<Message<Throwable>> error) {
        return messageFlux.flatMapSequential(m -> Flux.fromIterable(this.targets).concatMap(f -> {
            try {
                JsonNode result;
                Map<Object, Object> headersToBeAdded = new HashMap();
                if (f instanceof HeaderAware) {
                    HeaderAware headerAware = (HeaderAware)((Object)f);
                    headersToBeAdded = headerAware.headersToBeAdded((JsonNode)m.getPayload());
                }
                if ((result = (JsonNode)f.apply(((JsonNode)m.getPayload()).deepCopy())) == null) {
                    return Flux.empty();
                }
                MessageBuilder builder = MessageBuilder.withPayload((Object)result).copyHeaders((Map)m.getHeaders());
                headersToBeAdded.forEach((arg_0, arg_1) -> ((MessageBuilder)builder).setHeader(arg_0, arg_1));
                return Flux.just((Object)builder.build());
            }
            catch (Throwable t) {
                error.tryEmitNext((Object)MessageBuilder.withPayload((Object)t).copyHeaders((Map)m.getHeaders()).build());
                return Flux.empty();
            }
        }));
    }
}

