/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.batchfnlib;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.ct42.fnflow.batchdlt.BatchElement;
import org.ct42.fnflow.batchfnlib.MatchProperties;
import org.ct42.fnflow.batchfnlib.TemplateMatchError;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.MsearchTemplateRequest;
import org.opensearch.client.opensearch.core.MsearchTemplateResponse;
import org.opensearch.client.opensearch.core.msearch.MultiSearchResponseItem;
import org.opensearch.client.opensearch.core.msearch.MultisearchHeader;
import org.opensearch.client.opensearch.core.msearch_template.RequestItem;
import org.opensearch.client.opensearch.core.msearch_template.TemplateConfig;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.annotation.RegisterReflection;
import org.springframework.stereotype.Component;

@Component(value="Match")
@RegisterReflection(classes={JsonPointer.class}, memberCategories={MemberCategory.INVOKE_PUBLIC_METHODS})
public class Match
extends ConfigurableFunction<List<BatchElement>, List<BatchElement>, MatchProperties> {
    private final OpenSearchClient client;

    public List<BatchElement> apply(List<BatchElement> input) {
        ArrayList requestItems = new ArrayList();
        MultisearchHeader emptyHeader = new MultisearchHeader.Builder().build();
        input.forEach(batchElement -> {
            HashMap targetParams = new HashMap();
            ((MatchProperties)this.properties).getParamsFromInput().forEach((key, value) -> targetParams.put(key, JsonData.of((Object)batchElement.getInput().at(value))));
            ((MatchProperties)this.properties).getLiteralParams().forEach((key, value) -> targetParams.put(key, JsonData.of((Object)value)));
            requestItems.add(new RequestItem.Builder().header(emptyHeader).body(new TemplateConfig.Builder().id(((MatchProperties)this.properties).getTemplate()).params(targetParams).build()).build());
        });
        try {
            MsearchTemplateResponse response = this.client.msearchTemplate(new MsearchTemplateRequest.Builder().searchTemplates(requestItems).index(((MatchProperties)this.properties).getIndex(), new String[0]).build(), JsonNode.class);
            for (int i = 0; i < response.responses().size(); ++i) {
                MultiSearchResponseItem r = (MultiSearchResponseItem)response.responses().get(i);
                if (r.isResult()) {
                    ObjectNode result = JsonNodeFactory.instance.objectNode();
                    result.set("input", input.get(i).getInput());
                    ArrayNode matches = JsonNodeFactory.instance.arrayNode();
                    result.set("matches", (JsonNode)matches);
                    r.result().hits().hits().forEach(hit -> matches.add((JsonNode)hit.source()));
                    input.get(i).processWithOutput((JsonNode)result);
                    continue;
                }
                input.get(i).processWithError((Throwable)new TemplateMatchError(r.failure().error().reason()));
            }
        }
        catch (Exception e) {
            input.forEach(elem -> elem.processWithError((Throwable)e));
        }
        return input;
    }

    @Generated
    public Match(OpenSearchClient client) {
        this.client = client;
    }
}

