/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.batchfnlib.emit;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.ct42.fnflow.batchdlt.HeaderAware;
import org.ct42.fnflow.batchfnlib.emit.EmitProperties;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.opensearch.common.UUIDs;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.annotation.RegisterReflection;
import org.springframework.stereotype.Component;

@Component(value="ChangeEventEmit")
@RegisterReflection(classes={JsonPointer.class}, memberCategories={MemberCategory.INVOKE_PUBLIC_METHODS})
public class ChangeEventEmit
extends ConfigurableFunction<JsonNode, JsonNode, EmitProperties>
implements HeaderAware {
    public JsonNode apply(JsonNode input) {
        JsonNode contentNode = input.at(((EmitProperties)this.properties).getEventContent());
        if (contentNode.isObject()) {
            return contentNode;
        }
        return null;
    }

    public Map<String, Object> headersToBeAdded(JsonNode input) {
        String topic;
        JsonNode keyNode;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        JsonPointer keyPointer = ((EmitProperties)this.properties).getEventKey();
        if (keyPointer != null && !(keyNode = input.at(keyPointer)).isMissingNode() && !keyNode.isNull()) {
            if (keyNode.isTextual()) {
                headers.put("kafka_messageKey", keyNode.asText().getBytes(StandardCharsets.UTF_8));
            } else {
                headers.put("kafka_messageKey", keyNode.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        if (!headers.containsKey("kafka_messageKey")) {
            headers.put("kafka_messageKey", UUIDs.base64UUID().getBytes(StandardCharsets.UTF_8));
        }
        if ((topic = ((EmitProperties)this.properties).getTopic()) != null) {
            headers.put("spring.cloud.stream.sendto.destination", topic);
        }
        return headers;
    }
}

