/*
 * Copyright 2025-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ct42.fnflow.cfgfns;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * Configuration for Bean registry and AOT processor.
 *
 * @author Claas Thiele
 */
@Configuration
public class ConfigurableFunctionConfiguration {
    /**
     * Property prefix for configurable functions configurations.
     */
    public static final String FUNCTIONS_PREFIX = "cfgfns";


    @Bean
    public static ConfigurableFunctionRegistrar configurableFunctionRegistrar(Environment environment) {
        return new ConfigurableFunctionRegistrar(environment);
    }

    @Bean
    static ListenerBeanFactoryInitializationAotProcessor listenerBeanFactoryInitializationAotProcessor() {
        return new ListenerBeanFactoryInitializationAotProcessor();
    }
}
