/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.cfgfns;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class ConfigurableFunctionRegistrar
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private final Map<String, Map<String, Object>> functionCfgs;

    public ConfigurableFunctionRegistrar(Environment environment) {
        this.functionCfgs = (Map)Binder.get((Environment)environment).bind("cfgfns", Bindable.mapOf(String.class, Map.class)).get();
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        for (Map.Entry<String, Map<String, Object>> fnPrototypeCfg : this.functionCfgs.entrySet()) {
            for (String key : fnPrototypeCfg.getValue().keySet()) {
                if (registry.containsBeanDefinition(key)) continue;
                GenericBeanDefinition fnBeanDefinition = new GenericBeanDefinition(registry.getBeanDefinition(fnPrototypeCfg.getKey()));
                registry.registerBeanDefinition(key, (BeanDefinition)fnBeanDefinition);
            }
            if ("true".equals(System.getProperty("spring.aot.processing"))) continue;
            registry.removeBeanDefinition(fnPrototypeCfg.getKey());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }
}

