/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.cfgfns;

import java.lang.reflect.Field;
import lombok.Generated;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.springframework.aot.hint.annotation.RegisterReflectionForBinding;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.validation.ValidationBindHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.validation.Validator;

@Component
@RegisterReflectionForBinding(value={ConfigurableFunction.class})
public class FnPropsInjectingPostProcessor
implements BeanPostProcessor {
    private final ApplicationContext applicationContext;
    private final Validator validator;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ConfigurableFunction) {
            String fnCfgName = this.convertCamelCaseToKebap(bean.getClass().getSimpleName());
            ResolvableType fnPropertiesType = ResolvableType.forClass(bean.getClass()).as(ConfigurableFunction.class).getGeneric(new int[]{2});
            String cfgName = "cfgfns." + fnCfgName + "." + this.convertCamelCaseToKebap(beanName);
            ValidationBindHandler handler = new ValidationBindHandler(new BindHandler(this){}, new Validator[]{this.validator});
            BindResult bindResult = Binder.get((Environment)this.applicationContext.getEnvironment()).bind(cfgName, Bindable.of((Class)fnPropertiesType.resolve()), (BindHandler)handler);
            if (bindResult.isBound()) {
                Object props = bindResult.get();
                try {
                    Field propField = bean.getClass().getSuperclass().getDeclaredField("properties");
                    propField.setAccessible(true);
                    propField.set(bean, props);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException("Not able to access properties field in " + bean.getClass().getSimpleName(), e);
                }
            }
        }
        return bean;
    }

    private String convertCamelCaseToKebap(String input) {
        return input.replaceAll("([A-Z])(?=[A-Z])", "$1-").replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase();
    }

    @Generated
    public FnPropsInjectingPostProcessor(ApplicationContext applicationContext, Validator validator) {
        this.applicationContext = applicationContext;
        this.validator = validator;
    }
}

