/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.fnlib.normalizer.trim;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.ct42.fnflow.fnlib.normalizer.trim.TrimProperties;
import org.springframework.stereotype.Component;

@Component(value="trimNormalizer")
public class TrimNormalizer
extends ConfigurableFunction<JsonNode, JsonNode, TrimProperties> {
    public JsonNode apply(JsonNode input) {
        JsonNode parentNode;
        JsonPointer pointer = ((TrimProperties)this.properties).getElementPath();
        JsonNode resultNode = input.at(pointer);
        if (resultNode.isTextual() && (parentNode = input.at(pointer.head())).isObject()) {
            ((ObjectNode)parentNode).put(pointer.last().getMatchingProperty(), this.trimString(resultNode.asText()));
        }
        if (resultNode.isArray()) {
            ArrayNode array = (ArrayNode)resultNode;
            for (int i = 0; i < array.size(); ++i) {
                if (!array.get(i).isTextual()) continue;
                array.set(i, this.trimString(array.get(i).asText()));
            }
        }
        return input;
    }

    private String trimString(String input) {
        return switch (((TrimProperties)this.properties).getMode()) {
            default -> throw new MatchException(null, null);
            case TrimProperties.TrimMode.RIGHT -> StringUtils.stripStart((String)input, null);
            case TrimProperties.TrimMode.LEFT -> StringUtils.stripEnd((String)input, null);
            case TrimProperties.TrimMode.BOTH -> StringUtils.strip((String)input);
        };
    }
}

