/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.fnlib.merger;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.ct42.fnflow.fnlib.merger.MergeProperties;
import org.ct42.fnflow.fnlib.utils.TreeByPointerBuilder;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.annotation.RegisterReflection;
import org.springframework.stereotype.Component;

@Component(value="MergeCreate")
@RegisterReflection(classes={JsonPointer.class}, memberCategories={MemberCategory.INVOKE_PUBLIC_METHODS})
public class MergeCreate
extends ConfigurableFunction<JsonNode, JsonNode, MergeProperties> {
    public JsonNode apply(JsonNode input) {
        JsonNode inputObj = input.get("input");
        if (!inputObj.isNull() && input.get("matches").isArray() && !input.get("matches").isEmpty()) {
            Arrays.stream(((MergeProperties)this.properties).getMappings()).forEach(m -> {
                JsonNode from = inputObj.at(m.getFrom());
                JsonNode to = input.at("/matches/0/source");
                if (!from.isMissingNode() && to.isObject() && to.at(m.getTo()).isMissingNode()) {
                    TreeByPointerBuilder.buildAndSet(m.getTo(), (ObjectNode)to, from);
                }
            });
        }
        return input;
    }
}

