/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.fnlib.normalizer.pad;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.ct42.fnflow.fnlib.normalizer.pad.PadProperties;
import org.springframework.stereotype.Component;

@Component(value="padNormalizer")
public class PadNormalizer
extends ConfigurableFunction<JsonNode, JsonNode, PadProperties> {
    public JsonNode apply(JsonNode input) {
        JsonNode parentNode;
        JsonPointer pointer = ((PadProperties)this.properties).getElementPath();
        JsonNode resultNode = input.at(pointer);
        if (resultNode.isTextual() && (parentNode = input.at(pointer.head())).isObject()) {
            ((ObjectNode)parentNode).put(pointer.last().getMatchingProperty(), this.padString(resultNode.asText()));
        }
        if (resultNode.isArray()) {
            ArrayNode array = (ArrayNode)resultNode;
            for (int i = 0; i < array.size(); ++i) {
                if (!array.get(i).isTextual()) continue;
                array.set(i, this.padString(array.get(i).asText()));
            }
        }
        return input;
    }

    private String padString(String input) {
        return switch (((PadProperties)this.properties).getPad()) {
            default -> throw new MatchException(null, null);
            case PadProperties.Pad.LEFT -> StringUtils.leftPad((String)input, (int)((PadProperties)this.properties).getLength(), (char)((PadProperties)this.properties).getFillerCharacter());
            case PadProperties.Pad.RIGHT -> StringUtils.rightPad((String)input, (int)((PadProperties)this.properties).getLength(), (char)((PadProperties)this.properties).getFillerCharacter());
        };
    }
}

