/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.fnlib.utils;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;

public class TreeByPointerBuilder {
    public static void buildAndSet(JsonPointer pointer, ObjectNode targetRoot, JsonNode node) {
        ObjectNode parentNode;
        String name = pointer.last().toString().substring(1);
        JsonPointer parent = pointer.head();
        Object object = parentNode = parent.length() == 0 ? targetRoot : targetRoot.at(parent);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            if (StringUtils.isNumeric((CharSequence)name)) {
                parentNode = JsonNodeFactory.instance.arrayNode();
                int index = Integer.parseInt(name);
                for (int i = 0; i <= index; ++i) {
                    ((ArrayNode)parentNode).addNull();
                }
                ((ArrayNode)parentNode).set(index, node);
            } else {
                parentNode = JsonNodeFactory.instance.objectNode();
                parentNode.set(name, node);
            }
            TreeByPointerBuilder.buildAndSet(parent, targetRoot, (JsonNode)parentNode);
        } else {
            if (StringUtils.isNumeric((CharSequence)name) && !parentNode.isArray()) {
                throw new IllegalArgumentException("Node type mismatch");
            }
            if (StringUtils.isNumeric((CharSequence)name) && parentNode.isArray()) {
                int index = Integer.parseInt(name);
                for (int i = parentNode.size(); i <= index; ++i) {
                    ((ArrayNode)parentNode).addNull();
                }
                ((ArrayNode)parentNode).set(index, node);
            } else {
                parentNode.set(name, node);
            }
        }
    }
}

