/*
 * Decompiled with CFR 0.152.
 */
package org.ct42.fnflow.fnlib.script;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.ct42.fnflow.cfgfns.ConfigurableFunction;
import org.ct42.fnflow.fnlib.script.ScriptProperties;
import org.ct42.fnflow.fnlib.script.ScriptRunnerException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.springframework.stereotype.Component;

@Component(value="ScriptRunner")
public class ScriptRunner
extends ConfigurableFunction<JsonNode, JsonNode, ScriptProperties> {
    ObjectMapper mapper = new ObjectMapper();

    public JsonNode apply(JsonNode input) {
        Context context = Context.create((String[])new String[0]);
        try {
            context.getBindings("js").putMember("input", (Object)input.toString());
            Value evaluationResult = context.eval(((ScriptProperties)this.properties).getScript());
            Object raw = evaluationResult.as(Object.class);
            String json = this.mapper.writeValueAsString(raw);
            JsonNode jsonNode = this.mapper.readTree(json);
            return jsonNode;
        }
        catch (Exception e) {
            throw new ScriptRunnerException("Script: " + ((ScriptProperties)this.properties).getScript().getCharacters().toString(), e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

