/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.annotation.WillNotClose;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;

public final class CsvEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private CsvEscaper() {
    }

    public static String escape(CharSequence charSequence) {
        return charSequence == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charSequence, index), 0, charSequence.length());
    }

    @WillNotClose
    public static void escape(CharSequence charSequence, Writer writer) throws IOException {
        if (charSequence != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer);
        }
    }

    public static String escape(char[] charArr) {
        return charArr == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charArr, index), 0, charArr.length);
    }

    public static String escape(char[] charArr, int offset, int length) {
        return charArr == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charArr, index), offset, length);
    }

    @WillNotClose
    public static void escape(char[] charArr, Writer writer) throws IOException {
        if (charArr != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charArr, index), 0, charArr.length, writer);
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, int offset, int length, Writer writer) throws IOException {
        if (charArr != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charArr, index), offset, length, writer);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length) {
        try {
            StringWriter writer = new StringWriter();
            CsvEscaper.escape(codePointProvider, offset, length, (Writer)writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer) throws IOException {
        int charCount;
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        StringBuilder sb = new StringBuilder();
        boolean requiresQuotes = false;
        int end = offset + length;
        block4: for (int index = offset; index < end; index += charCount) {
            int cp = codePointProvider.codePointAt(index);
            charCount = Character.charCount(cp);
            switch (cp) {
                case 10: 
                case 13: 
                case 44: {
                    sb.appendCodePoint(cp);
                    requiresQuotes = true;
                    continue block4;
                }
                case 34: {
                    sb.append("\"\"");
                    requiresQuotes = true;
                    continue block4;
                }
                default: {
                    sb.appendCodePoint(cp);
                }
            }
        }
        if (requiresQuotes) {
            writer.write(34);
            writer.write(sb.toString());
            writer.write(34);
        } else {
            writer.write(sb.toString());
        }
    }
}

