/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

final class HexUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtils() {
    }

    static void writeHex2(int value, Writer writer) throws IOException {
        writer.write(HEX_DIGITS[value >> 4 & 0xF]);
        writer.write(HEX_DIGITS[value & 0xF]);
    }

    static void writeHex4(int value, Writer writer) throws IOException {
        writer.write(HEX_DIGITS[value >> 12 & 0xF]);
        writer.write(HEX_DIGITS[value >> 8 & 0xF]);
        writer.write(HEX_DIGITS[value >> 4 & 0xF]);
        writer.write(HEX_DIGITS[value & 0xF]);
    }

    static void writeHex8(int value, Writer writer) throws IOException {
        writer.write(HEX_DIGITS[value >> 28 & 0xF]);
        writer.write(HEX_DIGITS[value >> 24 & 0xF]);
        writer.write(HEX_DIGITS[value >> 20 & 0xF]);
        writer.write(HEX_DIGITS[value >> 16 & 0xF]);
        writer.write(HEX_DIGITS[value >> 12 & 0xF]);
        writer.write(HEX_DIGITS[value >> 8 & 0xF]);
        writer.write(HEX_DIGITS[value >> 4 & 0xF]);
        writer.write(HEX_DIGITS[value & 0xF]);
    }

    static void writeHex(int value, Writer writer) throws IOException {
        writer.write(Integer.toHexString(value).toUpperCase(Locale.ENGLISH));
    }
}

