/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.WillNotClose;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;
import org.cthing.escapers.HtmlEntities;

public final class HtmlEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private HtmlEscaper() {
    }

    public static String escape(CharSequence charSequence, Option ... options) {
        return charSequence == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(CharSequence charSequence, Set<Option> options) {
        return charSequence == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), options);
    }

    @WillNotClose
    public static void escape(CharSequence charSequence, Writer writer, Option ... options) throws IOException {
        if (charSequence != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(CharSequence charSequence, Writer writer, Set<Option> options) throws IOException {
        if (charSequence != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, options);
        }
    }

    public static String escape(char[] charArr, Option ... options) {
        return charArr == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(char[] charArr, int offset, int length, Option ... options) {
        return charArr == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(char[] charArr, Set<Option> options) {
        return charArr == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, options);
    }

    public static String escape(char[] charArr, int offset, int length, Set<Option> options) {
        return charArr == null ? null : HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, options);
    }

    @WillNotClose
    public static void escape(char[] charArr, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, int offset, int length, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, (Set<Option>)HtmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, options);
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            HtmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, options);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length, Set<Option> options) {
        try {
            StringWriter writer = new StringWriter();
            HtmlEscaper.escape(codePointProvider, offset, length, (Writer)writer, options);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        int cp2;
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        CharEscaper charEscaper = options.contains((Object)Option.USE_DECIMAL) ? AbstractEscaper::escapeDecimalEntity : AbstractEscaper::escapeHexEntity;
        boolean escapeNonAscii = options.contains((Object)Option.ESCAPE_NON_ASCII);
        boolean useLatin1 = options.contains((Object)Option.USE_ISO_LATIN_1_ENTITIES);
        boolean useExtended = options.contains((Object)Option.USE_HTML4_EXTENDED_ENTITIES);
        Function<Integer, String> findEntity = !useLatin1 && !useExtended ? HtmlEntities.MARKUP_SIGNIFICANT::get : cp -> {
            String entity = HtmlEntities.MARKUP_SIGNIFICANT.get(cp);
            if (entity != null) {
                return entity;
            }
            if (useLatin1 && (entity = HtmlEntities.ISO_LATIN_1.get(cp)) != null) {
                return entity;
            }
            return useExtended ? HtmlEntities.HTML4_EXTENDED.get(cp) : null;
        };
        int end = offset + length;
        block4: for (int index = offset; index < end; index += Character.charCount(cp2)) {
            cp2 = codePointProvider.codePointAt(index);
            String entity = findEntity.apply(cp2);
            if (entity != null) {
                writer.write(entity);
                continue;
            }
            switch (cp2) {
                case 39: {
                    charEscaper.escape(cp2, writer);
                    continue block4;
                }
                case 9: 
                case 10: 
                case 13: {
                    writer.write(cp2);
                    continue block4;
                }
                default: {
                    if (cp2 > 31 && cp2 < 127) {
                        writer.write(cp2);
                        continue block4;
                    }
                    if (cp2 == 127) {
                        charEscaper.escape(cp2, writer);
                        continue block4;
                    }
                    if (escapeNonAscii) {
                        if (!(cp2 >= 128 && cp2 <= 55295 || cp2 >= 57344 && cp2 <= 65533) && (cp2 < 65536 || cp2 > 0x10FFFF)) continue block4;
                        charEscaper.escape(cp2, writer);
                        continue block4;
                    }
                    if (cp2 >= 128 && cp2 <= 55295 || cp2 >= 57344 && cp2 <= 65533) {
                        writer.write(cp2);
                        continue block4;
                    }
                    if (cp2 < 65536 || cp2 > 0x10FFFF) continue block4;
                    writer.write(Character.toChars(cp2));
                }
            }
        }
    }

    public static enum Option {
        USE_DECIMAL,
        ESCAPE_NON_ASCII,
        USE_ISO_LATIN_1_ENTITIES,
        USE_HTML4_EXTENDED_ENTITIES;

    }

    @FunctionalInterface
    private static interface CharEscaper {
        public void escape(int var1, Writer var2) throws IOException;
    }
}

