/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.WillNotClose;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;

public final class JavaEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private JavaEscaper() {
    }

    public static String escape(CharSequence charSequence, Option ... options) {
        return charSequence == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(CharSequence charSequence, Set<Option> options) {
        return charSequence == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), options);
    }

    @WillNotClose
    public static void escape(CharSequence charSequence, Writer writer, Option ... options) throws IOException {
        if (charSequence != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(CharSequence charSequence, Writer writer, Set<Option> options) throws IOException {
        if (charSequence != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, options);
        }
    }

    public static String escape(char[] charArr, Option ... options) {
        return charArr == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(char[] charArr, int offset, int length, Option ... options) {
        return charArr == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static String escape(char[] charArr, Set<Option> options) {
        return charArr == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, options);
    }

    public static String escape(char[] charArr, int offset, int length, Set<Option> options) {
        return charArr == null ? null : JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, options);
    }

    @WillNotClose
    public static void escape(char[] charArr, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, int offset, int length, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, (Set<Option>)JavaEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, options);
        }
    }

    @WillNotClose
    public static void escape(char[] charArr, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            JavaEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, options);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length, Set<Option> options) {
        try {
            StringWriter writer = new StringWriter();
            JavaEscaper.escape(codePointProvider, offset, length, (Writer)writer, options);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        int charCount;
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        boolean escapeSpace = options.contains((Object)Option.ESCAPE_SPACE);
        boolean escapeNonAscii = options.contains((Object)Option.ESCAPE_NON_ASCII);
        int end = offset + length;
        block10: for (int index = offset; index < end; index += charCount) {
            int cp = codePointProvider.codePointAt(index);
            charCount = Character.charCount(cp);
            switch (cp) {
                case 34: {
                    writer.write("\\\"");
                    continue block10;
                }
                case 92: {
                    writer.write("\\\\");
                    continue block10;
                }
                case 10: {
                    writer.write("\\n");
                    continue block10;
                }
                case 13: {
                    writer.write("\\r");
                    continue block10;
                }
                case 12: {
                    writer.write("\\f");
                    continue block10;
                }
                case 9: {
                    writer.write("\\t");
                    continue block10;
                }
                case 8: {
                    writer.write("\\b");
                    continue block10;
                }
                case 32: {
                    if (escapeSpace) {
                        writer.write("\\s");
                        continue block10;
                    }
                    writer.write(32);
                    continue block10;
                }
                default: {
                    if (charCount == 1) {
                        if (cp < 32 || cp == 127 || escapeNonAscii && cp > 127) {
                            JavaEscaper.escapeUnicode(cp, writer);
                            continue block10;
                        }
                        writer.write(cp);
                        continue block10;
                    }
                    if (escapeNonAscii) {
                        for (char ch : Character.toChars(cp)) {
                            JavaEscaper.escapeUnicode(ch, writer);
                        }
                        continue block10;
                    }
                    writer.write(Character.toChars(cp));
                }
            }
        }
    }

    public static enum Option {
        ESCAPE_SPACE,
        ESCAPE_NON_ASCII;

    }
}

